% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsum.test.R
\name{tsum.test}
\alias{tsum.test}
\title{Summarized t-test}
\usage{
tsum.test(mean.x, s.x = NULL, n.x = NULL, mean.y = NULL, s.y = NULL,
  n.y = NULL, alternative = "two.sided", mu = 0, var.equal = FALSE,
  conf.level = 0.95)
}
\arguments{
\item{mean.x}{a single number representing the sample mean of \code{x}}

\item{s.x}{a single number representing the sample standard deviation for
\code{x}}

\item{n.x}{a single number representing the sample size for \code{x}}

\item{mean.y}{a single number representing the sample mean of \code{y}}

\item{s.y}{a single number representing the sample standard deviation for
\code{y}}

\item{n.y}{a single number representing the sample size for \code{y}}

\item{alternative}{is a character string, one of \code{"greater"},
\code{"less"} or \code{"two.sided"}, or just the initial letter of each,
indicating the specification of the alternative hypothesis. For one-sample
tests, \code{alternative} refers to the true mean of the parent population
in relation to the hypothesized value \code{mu}.  For the standard
two-sample tests, \code{alternative} refers to the difference between the
true population mean for \code{x} and that for \code{y}, in relation to
\code{mu}.  For the one-sample and paired t-tests, \code{alternative} refers
to the true mean of the parent population in relation to the hypothesized
value \code{mu}. For the standard and Welch modified two-sample t-tests,
\code{alternative} refers to the difference between the true population mean
for \code{x} and that for \code{y}, in relation to \code{mu}.  For the
one-sample t-tests, alternative refers to the true mean of the parent
population in relation to the hypothesized value \code{mu}. For the standard
and Welch modified two-sample t-tests, alternative refers to the difference
between the true population mean for \code{x} and that for \code{y}, in
relation to \code{mu}.}

\item{mu}{is a single number representing the value of the mean or
difference in means specified by the null hypothesis.}

\item{var.equal}{logical flag: if \code{TRUE}, the variances of the parent
populations of \code{x} and \code{y} are assumed equal. Argument
\code{var.equal} should be supplied only for the two-sample tests.}

\item{conf.level}{is the confidence level for the returned confidence
interval; it must lie between zero and one.}
}
\value{
A list of class \code{htest}, containing the following components:
\item{statistic}{the t-statistic, with names attribute \code{"t"}}
\item{parameters}{is the degrees of freedom of the t-distribution associated
with statistic.  Component \code{parameters} has names attribute
\code{"df"}.} \item{p.value}{the p-value for the test.} \item{conf.int }{is
a confidence interval (vector of length 2) for the true mean or difference
in means. The confidence level is recorded in the attribute
\code{conf.level}. When alternative is not \code{"two.sided"}, the
confidence interval will be half-infinite, to reflect the interpretation of
a confidence interval as the set of all values \code{k} for which one would
not reject the null hypothesis that the true mean or difference in means is
\code{k} . Here infinity will be represented by \code{Inf}.}
\item{estimate}{vector of length 1 or 2, giving the sample mean(s) or mean
of differences; these estimate the corresponding population parameters.
Component \code{estimate} has a names attribute describing its elements.}
\item{null.value}{the value of the mean or difference in means specified by
the null hypothesis. This equals the input argument \code{mu}. Component
\code{null.value} has a names attribute describing its elements.}
\item{alternative}{records the value of the input argument alternative:
\code{"greater"} , \code{"less"} or \code{"two.sided"}.} \item{data.name}{a
character string (vector of length 1) containing the names x and y for the
two summarized samples.}
}
\description{
Performs a one-sample, two-sample, or a Welch modified two-sample t-test
based on user supplied summary information. Output is identical to that
produced with \code{t.test}.
}
\details{
If \code{y} is \code{NULL}, a one-sample t-test is carried out with
\code{x}. If y is not \code{NULL}, either a standard or Welch modified
two-sample t-test is performed, depending on whether \code{var.equal} is
\code{TRUE} or \code{FALSE}.
}
\section{Null Hypothesis}{
 For the one-sample t-test, the null hypothesis is
that the mean of the population from which \code{x} is drawn is \code{mu}.
For the standard and Welch modified two-sample t-tests, the null hypothesis
is that the population mean for \code{x} less that for \code{y} is
\code{mu}.

The alternative hypothesis in each case indicates the direction of
divergence of the population mean for \code{x} (or difference of means for
\code{x} and \code{y}) from \code{mu} (i.e., \code{"greater"},
\code{"less"}, or \code{"two.sided"}).
}

\examples{

tsum.test(mean.x=5.6, s.x=2.1, n.x=16, mu=4.9, alternative="greater")
        # Problem 6.31 on page 324 of BSDA states:  The chamber of commerce
        # of a particular city claims that the mean carbon dioxide
        # level of air polution is no greater than 4.9 ppm.  A random
        # sample of 16 readings resulted in a sample mean of 5.6 ppm,
        # and s=2.1 ppm.  One-sided one-sample t-test.  The null 
        # hypothesis is that the population mean for 'x' is 4.9.   
        # The alternative hypothesis states that it is greater than 4.9.  

x <- rnorm(12) 
tsum.test(mean(x), sd(x), n.x=12)
        # Two-sided one-sample t-test. The null hypothesis is that  
        # the population mean for 'x' is zero. The alternative 
        # hypothesis states  that it is either greater or less 
        # than zero. A confidence interval for the population mean 
        # will be computed.  Note: above returns same answer as: 
t.test(x)
   
x <- c(7.8, 6.6, 6.5, 7.4, 7.3, 7.0, 6.4, 7.1, 6.7, 7.6, 6.8) 
y <- c(4.5, 5.4, 6.1, 6.1, 5.4, 5.0, 4.1, 5.5) 
tsum.test(mean(x), s.x=sd(x), n.x=11 ,mean(y), s.y=sd(y), n.y=8, mu=2)
        # Two-sided standard two-sample t-test.  The null hypothesis  
        # is that the population mean for 'x' less that for 'y' is 2. 
        # The alternative hypothesis is that this difference is not 2. 
        # A confidence interval for the true difference will be computed.
        # Note: above returns same answer as: 
t.test(x, y)
        
tsum.test(mean(x), s.x=sd(x), n.x=11, mean(y), s.y=sd(y), n.y=8, conf.level=0.90)
        # Two-sided standard two-sample t-test.  The null hypothesis 
        # is that the population mean for 'x' less that for 'y' is zero.  
        # The alternative hypothesis is that this difference is not
        # zero.  A 90\% confidence interval for the true difference will 
        # be computed.  Note: above returns same answer as:
t.test(x, y, conf.level=0.90)


}
\references{
Kitchens, L.J. (2003). \emph{Basic Statistics and Data
Analysis}. Duxbury.

Hogg, R. V. and Craig, A. T. (1970). \emph{Introduction to Mathematical
Statistics, 3rd ed}. Toronto, Canada: Macmillan.

Mood, A. M., Graybill, F. A. and Boes, D. C. (1974). \emph{Introduction to
the Theory of Statistics, 3rd ed}. New York: McGraw-Hill.

Snedecor, G. W. and Cochran, W. G. (1980). \emph{Statistical Methods, 7th
ed}. Ames, Iowa: Iowa State University Press.
}
\seealso{
\code{\link{z.test}}, \code{\link{zsum.test}}
}
\author{
Alan T. Arnholt
}
\keyword{htest}
