% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Elderly}
\alias{Elderly}
\title{Percent of the population over the age of 65}
\format{
A data frame/tibble with 51 observations on three variables
\describe{ 
\item{state}{a factor with levels \code{Alabama},
\code{Alaska}, \code{Arizona}, \code{Arkansas}, \code{California},
\code{Colorado}, \code{Connecticut}, \code{Delaware}, \code{District of
Colunbia}, \code{Florida}, \code{Georgia}, \code{Hawaii}, \code{Idaho},
\code{Illinois}, \code{Indiana}, \code{Iowa}, \code{Kansas}, \code{Kentucky},
\code{Louisiana}, \code{Maine}, \code{Maryland}, \code{Massachusetts},
\code{Michigan}, \code{Minnesota}, \code{Mississippi}, \code{Missour},
\code{Montana}, \code{Nebraska}, \code{Nevada}, \code{New Hampshire}, \code{New
Jersey}, \code{New Mexico}, \code{New York}, \code{North Carolina}, \code{North
Dakota}, \code{Ohio}, \code{Oklahoma}, \code{Oregon}, \code{Pennsylvania},
\code{Rhode Island}, \code{South Carolina}, \code{South Dakota},
\code{Tennessee}, \code{Texas}, \code{Utah}, \code{Vermont}, \code{Virginia},
\code{Washington}, \code{West Virginia}, \code{Wisconsin}, and \code{Wyoming}}
\item{percent1985}{percent of the population over the age of 65 in 1985} 
\item{percent1998}{percent of the population over the age of 65 in 1998} 
}
}
\source{
U.S. Census Bureau Internet site, February 2000.
}
\usage{
Elderly
}
\description{
Data for Exercise 1.92 and 2.61
}
\examples{

with(data = Elderly, 
stripchart(x = list(percent1998, percent1985), method = "stack", pch = 19,
           col = c("red","blue"), group.names = c("1998", "1985"))
           )
with(data = Elderly, cor(percent1998, percent1985))
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Elderly, aes(x = percent1985, y = percent1998)) +
           geom_point() + 
           theme_bw()
}
}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
