% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectPenalty.R
\name{selectPenalty}
\alias{selectPenalty}
\title{Selecting BSLasso Penalty}
\usage{
selectPenalty(ssy, n, lambda_all, theta, M, sigma, fn_sim, fn_sum,
  sim_options = NULL, sum_options = NULL, standardise = FALSE,
  parallel_sim = FALSE, parallel_sim_packages = NULL,
  parallel_main = FALSE, verbose = TRUE)
}
\arguments{
\item{ssy}{A summary statistic vector for the observed data.}

\item{n}{A vector of possible values of \code{n}, the number of simulations from the model per MCMC iteration, to test.}

\item{lambda_all}{A list, with each entry containing the vector of penalty values to test for the corresponding choice of \code{n}.}

\item{theta}{A point estimate of the parameter value which all of the simulations will be based on.}

\item{M}{The number of repeats to use in estimating the standard deviation of the estimated log synthetic likelihood.}

\item{sigma}{The standard deviation of the log synthetic likelihood to aim for.}

\item{fn_sim}{A function that simulates data for a given parameter value. The function can have at most two arguments.
The first is the vector of tuning parameters and the second (optional) argument is a list of other necessary arguments. See \code{sim_options}.}

\item{fn_sum}{A function for computing summary statistics of data. The function can have at most two arguments.
The first is the vector of tuning parameters and the second (optional) argument is a list of other necessary arguments. See \code{sum_options}.}

\item{sim_options}{A list of additional arguments to pass into the simulation function. Only use when the input \code{fn_sim} requires additional arguments. The default is \code{NULL}.}

\item{sum_options}{A list of additional arguments to pass into the summary statistic function. Only use when the input \code{fn_sum} requires additional arguments. The default is \code{NULL}.}

\item{standardise}{A logical argument that determines whether to standardise the summary statistics before applying the graphical lasso. This is only valid if penalty is not \code{NULL}.
The diagonal elements will not be penalised if the penalty is not \code{NULL}. The default is \code{FALSE}.}

\item{parallel_sim}{A logical value indicating whether parallel computing should be used for simulation and summary statistic evaluation. Default is \code{FALSE}.}

\item{parallel_sim_packages}{A character vector of package names to pass into the \code{foreach} function as argument '.package'. Only used when \code{parallel_sim} is \code{TRUE}, default is \code{NULL}.}

\item{parallel_main}{A logical value indicating whether parallel computing should be used to computing the graphical lasso function. Default is \code{FALSE}.}

\item{verbose}{A logical argument indicating whether the iteration numbers (\code{1:M}) should be printed to track progress. The default is \code{FALSE}.}
}
\value{
An object of class \code{penbsl} is returned, containing the following components:
\itemize{
\item \code{resultsDF}: A data frame containing the following:
   \itemize{
   \item \code{n}: The choices of \code{n} that were specified.
   \item \code{penalty}: The choices of the penalty that were specified.
   \item \code{sigma}: The standard deviation of the log synthetic likelihood under the above choices.
   \item \code{sigmaOpt}: An indicator of whether it was the closest \code{sigma} to the desired one for each choice of \code{n}.
   }
\item \code{call}: The original code that was used to call the method.
}
The functions print() and plot() are both available for types of class \code{penbsl}.
}
\description{
This is the main function for selecting the penalty for BSLasso based on a point estimate of the parameters. 
Parallel computing is supported with the R package \code{foreach}.
}
\references{
An, Z., South, L. F., Nott, D. J. &  Drovandi, C. C. (2018). Accelerating
Bayesian synthetic likelihood with the graphical lasso. https://eprints.qut.edu.au/102263/
}
\seealso{
\code{\link{bsl}} for a function to run BSLasso after selecting the tuning parameter
and \code{\link{plot}} for functions related to visualisation.
}
\author{
Ziwen An, Christopher C. Drovandi and Leah F. South
}
