% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussianSynLikeGhuryeOlkin.R
\name{gaussianSynLikeGhuryeOlkin}
\alias{gaussianSynLikeGhuryeOlkin}
\title{Estimating the Gaussian synthetic likelihood with an unbiased estimator}
\usage{
gaussianSynLikeGhuryeOlkin(ssy, ssx, log = TRUE, verbose = FALSE)
}
\arguments{
\item{ssy}{The observed summary statisic.}

\item{ssx}{A matrix of the simulated summary statistics. The number of rows is the same
as the number of simulations per iteration.}

\item{log}{A logical argument indicating if the log of likelihood is given as the result.
The default is \code{TRUE}.}

\item{verbose}{A logical argument indicating whether an error message should be printed if
the function fails to compute a likelihood. The default is \code{FALSE}.}
}
\value{
The estimated synthetic (log) likelihood value.
}
\description{
This function computes an unbiased, nonnegative estimate of a normal density 
function from simulations assumed to be drawn from it. See Price et al. (2018) and Ghurye 
and Olkin (1969).
}
\examples{
data(ma2)
y <- ma2$data # the observed data

theta_true <- c(0.6, 0.2)
x <- matrix(0, 300, 50)
set.seed(100)
for(i in 1:300) x[i, ] <- ma2_sim(theta_true, 50)

# unbiased estimate of the Gaussian synthetic likelihood
# (the likelihood estimator used in uBSL)
gaussianSynLikeGhuryeOlkin(y, x)

}
\references{
Price, L. F., Drovandi, C. C., Lee, A., & Nott, D. J. (2018).
Bayesian synthetic likelihood. Journal of Computational and Graphical Statistics.
\url{https://doi.org/10.1080/10618600.2017.1302882}

Ghurye, S. G., & Olkin, I. (1969).
Unbiased estimation of some multivariate probability densities and related functions.
The Annals of Mathematical Statistics. \url{https://projecteuclid.org/euclid.aoms/1177697501}
}
\seealso{
\code{\link{gaussianSynLike}} for the standard synthetic likelihood estimator, 
\code{\link{semiparaKernelEstimate}} for the semi-parametric likelihood estimator.
}
