% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussianRankCorr.R
\name{gaussianRankCorr}
\alias{gaussianRankCorr}
\title{Gaussian rank correlation}
\usage{
gaussianRankCorr(x, vec = FALSE)
}
\arguments{
\item{x}{A numeric matrix representing data where the number of rows
is the number of independent data points and the number of columns is the
number of variables in the dataset.}

\item{vec}{A logical argument indicating if the vector of correlations
should be returned instead of a matrix.}
}
\value{
Gaussian rank correlation matrix (default) or a vector of
  pair correlations.
}
\description{
This function computes the Gaussian rank correlation of
  \insertCite{Boudt2012;textual}{BSL}.
}
\examples{
data(ma2)
model <- newModel(fnSimVec = ma2_sim_vec, fnSum = ma2_sum, simArgs = list(TT = 10),
                  theta0 = ma2$start, fnLogPrior = ma2_prior)
set.seed(100)

# generate 1000 simualtions from the ma2 model
x <- simulation(model, n = 1000, theta = c(0.6, 0.2))$x

corr1 <- cor(x) # traditional correlation matrix
corr2 <- gaussianRankCorr(x) # Gaussian rank correlation matrix
oldpar <- par()
par(mfrow = c(1, 2))
image(corr1, main = 'traditional correlation matrix')
image(corr2, main = 'Gaussian rank correlation matrix')
par(mfrow = oldpar$mfrow)

std <- apply(x, MARGIN = 2, FUN = sd) # standard deviations
cor2cov(gaussianRankCorr(x), std) # convert to covariance matrix

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cor2cov}} for conversion from correlation matrix
  to covariance matrix.
}
