% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgbb.R
\name{bgbb.DERT}
\alias{bgbb.DERT}
\title{BG/BB Discounted Expected Residual Transactions}
\usage{
bgbb.DERT(params, x, t.x, n.cal, d)
}
\arguments{
\item{params}{BG/BB parameters - a vector with alpha, beta, gamma, and
delta, in that order. Alpha and beta are unobserved parameters for the
beta-Bernoulli transaction process. Gamma and delta are unobserved
parameters for the beta-geometric dropout process.}

\item{x}{the number of repeat transactions made by the customer in the
calibration period. Can also be vector of frequencies - see details.}

\item{t.x}{recency - the transaction opportunity in which the customer made
their last transaction. Can also be a vector of recencies - see details.}

\item{n.cal}{number of transaction opportunities in the calibration
period. Can also be a vector of calibration period transaction
opportunities - see details.}

\item{d}{discount rate.}
}
\value{
The present value of the expected future transaction stream for a particular customer.
}
\description{
Computes the number of discounted expected residual transactions by a
customer, conditional on their behavior in the calibration period.
}
\details{
DERT(d | alpha, beta, gamma, delta, x, t.x, n). This is the present value of
the expected future transaction stream for a customer with x transactions and
a recency of t.x in n.cal transaction opportunities, discounted by a rate d.

\code{x}, \code{t.x}, and \code{n.cal} may be vectors. The standard rules for vector
operations apply - if they are not of the same length, shorter vectors will
be recycled (start over at the first element) until they are as long as the
longest vector. It is advisable to keep vectors to the same length and to use
single values for parameters that are to be the same for all calculations. If
one of these parameters has a length greater than one, the output will be
also be a vector.
}
\examples{
params <- c(1.20, 0.75, 0.66, 2.78)
# Compute DERT for a customer who made 3 transactions
# in the calibration period(consisting of 6 transaction
# opportunities), with the last transaction occurring
# during the 4th transaction opportunity, discounted at
# 10\%.
bgbb.DERT(params, x=3, t.x=4, n.cal=6, d=0.1)

# We can also compare DERT for several customers:
bgbb.DERT(params, x=1:6, t.x=6, n.cal=6, d=0.1)
}
\references{
Fader, Peter S., Bruce G.S. Hardie, and Jen Shang.
"Customer-Base Analysis in a Discrete-Time Noncontractual Setting."
\emph{Marketing Science} 29(6), pp. 1086-1108. 2010. INFORMS.
\href{http://www.brucehardie.com/papers/020/}{Web.}
See equation 14.
}
