% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.PlotTrackingCum}
\alias{bgnbd.PlotTrackingCum}
\title{BG/NBD Tracking Cumulative Transactions Plot}
\usage{
bgnbd.PlotTrackingCum(
  params,
  T.cal,
  T.tot,
  actual.cu.tracking.data,
  n.periods.final = NA,
  hardie = TRUE,
  xlab = "Week",
  ylab = "Cumulative Transactions",
  xticklab = NULL,
  title = "Tracking Cumulative Transactions"
)
}
\arguments{
\item{params}{BG/NBD parameters - a vector with r, alpha, a, and b, in that
order. r and alpha are unobserved parameters for the NBD transaction
process. a and b are unobserved parameters for the Beta geometric dropout
process.}

\item{T.cal}{a vector to represent customers' calibration period lengths
(in other words, the "T.cal" column from a customer-by-sufficient-statistic
matrix).}

\item{T.tot}{end of holdout period. Must be a single value, not a vector.}

\item{actual.cu.tracking.data}{vector containing the cumulative number of
repeat transactions made by customers for each period in the total time
period (both calibration and holdout periods). See details.}

\item{n.periods.final}{number of time periods in the calibration and
holdout periods. See details.}

\item{hardie}{if TRUE, use h2f1 instead of hypergeo.}

\item{xlab}{descriptive label for the x axis.}

\item{ylab}{descriptive label for the y axis.}

\item{xticklab}{vector containing a label for each tick mark on the x axis.}

\item{title}{title placed on the top-center of the plot.}
}
\value{
Matrix containing actual and expected cumulative repeat transactions.
}
\description{
Plots the actual and expected cumulative total repeat transactions by all
customers for the calibration and holdout periods, and returns this
comparison in a matrix.
}
\details{
actual.cu.tracking.data does not have to be in the same unit of time as the
T.cal data. T.tot will automatically be divided into periods to match the
length of actual.cu.tracking.data. See
\link{bgnbd.ExpectedCumulativeTransactions}.

The holdout period should immediately follow the calibration period. This
function assume that all customers' calibration periods end on the same date,
rather than starting on the same date (thus customers' birth periods are
determined using max(T.cal) - T.cal rather than assuming that it is 0).
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

# Cumulative repeat transactions made by all customers across calibration
# and holdout periods
cu.tracking <- cdnowSummary$cu.tracking

# parameters estimated using bgnbd.EstimateParameters
est.params <- c(0.243, 4.414, 0.793, 2.426)

# All parameters are in weeks; the calibration period lasted 39
# weeks and the holdout period another 39.
bgnbd.PlotTrackingCum(est.params, 
                      T.cal = cal.cbs[,"T.cal"], 
                      T.tot = 78, 
                      actual.cu.tracking.data = cu.tracking, 
                      hardie = TRUE)
}
