% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.DERT}
\alias{pnbd.DERT}
\title{Pareto/NBD Discounted Expected Residual Transactions}
\usage{
pnbd.DERT(params, x, t.x, T.cal, d, hardie = TRUE)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{x}{number of repeat transactions in the calibration period T.cal, or a
vector of transaction frequencies.}

\item{t.x}{time of most recent repeat transaction, or a vector of recencies.}

\item{T.cal}{length of calibration period, or a vector of calibration period
lengths.}

\item{d}{the discount rate to be used. Make sure that it matches up with your
chosen time period (do not use an annual rate for monthly data, for
example).}

\item{hardie}{if TRUE, use \code{\link{h2f1}} instead of
\code{\link[hypergeo]{hypergeo}}.}
}
\value{
The number of discounted expected residual transactions for a
customer with a particular purchase pattern during the calibration period.
}
\description{
Calculates the discounted expected residual transactions of a customer, given
their behavior during the calibration period.
}
\details{
DERT(d | r, alpha, s, beta, X = x, t.x, T.cal)

x, t.x, T.cal may be vectors. The standard rules for vector operations apply
\itemize{
\item if they are not of the same length, shorter vectors will be recycled (start
over at the first element) until they are as long as the longest vector. It
is advisable to keep vectors to the same length and to use single values for
parameters that are to be the same for all calculations. If one of these
parameters has a length greater than one, the output will be also be a
vector.
}
}
\examples{
# elog <- dc.ReadLines(system.file("data/cdnowElog.csv", package="BTYD2"),2,3)
# elog[, 'date'] <- as.Date(elog[, 'date'], format = '\%Y\%m\%d')
# cal.cbs <- dc.ElogToCbsCbt(elog)$cal$cbs
# params <- pnbd.EstimateParameters(cal.cbs, hardie = TRUE)
params <- c(0.5629966, 12.5590370, 0.4081095, 10.5148048)

# 15\% compounded annually has been converted to 0.0027 compounded continuously,
# as we are dealing with weekly data and not annual data.
d <- 0.0027

# calculate the discounted expected residual transactions of a customer
# who made 7 transactions in a calibration period that was 77.86
# weeks long, with the last transaction occurring at the end of
# the 35th week.
pnbd.DERT(params, 
          x = 7, 
          t.x = 35, 
          T.cal = 77.86, 
          d, 
          hardie = TRUE)

# We can also use vectors to compute DERT for several customers:
pnbd.DERT(params, 
          x = 1:10, 
          t.x = 30, 
          T.cal = 77.86, 
          d, 
          hardie = TRUE)
}
\references{
Fader, Peter S., Bruce G.S. Hardie, and Ka L. Lee. "RFM and CLV:
Using Iso-Value Curves for Customer Base Analysis." Journal of Marketing
Research Vol.42, pp.415-430. November. 2005.
\url{http://www.brucehardie.com/papers.html}

See equation 2.

Note that this paper refers to what this package is calling
discounted expected residual transactions (DERT) simply as discounted
expected transactions (DET).
}
