% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto-nbd-abe.R
\name{abe.GenerateData}
\alias{abe.GenerateData}
\title{Simulate data according to Pareto/NBD (Abe) model assumptions}
\usage{
abe.GenerateData(
  n,
  T.cal,
  T.star,
  params,
  date.zero = "2000-01-01",
  covariates = NULL
)
}
\arguments{
\item{n}{Number of customers.}

\item{T.cal}{Length of calibration period. If a vector is provided, then it
is assumed that customers have different 'birth' dates, i.e.
\eqn{max(T.cal)-T.cal}.}

\item{T.star}{Length of holdout period. This may be a vector.}

\item{params}{A list of model parameters: \code{beta} and \code{gamma}.}

\item{date.zero}{Initial date for cohort start. Can be of class character, Date or POSIXt.}

\item{covariates}{Provide matrix of customer covariates. If NULL then random covariate values between [-1,1] are drawn.}
}
\value{
List of length 2:
\item{\code{cbs}}{A data.frame with a row for each customer and the summary statistic as columns.}
\item{\code{elog}}{A data.frame with a row for each transaction, and columns \code{cust}, \code{date} and \code{t}.}
}
\description{
Simulate data according to Pareto/NBD (Abe) model assumptions
}
\examples{
# generate artificial Pareto/NBD (Abe) with 2 covariates
params <- list()
params$beta  <- matrix(c(0.18, -2.5, 0.5, -0.3, -0.2, 0.8), byrow = TRUE, ncol = 2)
params$gamma <- matrix(c(0.05, 0.1, 0.1, 0.2), ncol = 2)
data <- abe.GenerateData(n = 200, T.cal = 32, T.star = 32, params)
cbs <- data$cbs  # customer by sufficient summary statistic - one row per customer
elog <- data$elog  # Event log - one row per event/purchase
}
