% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.cbs.LL}
\alias{mbgcnbd.cbs.LL}
\alias{mbgcnbd.LL}
\alias{bgcnbd.cbs.LL}
\alias{bgcnbd.LL}
\title{(M)BG/CNBD-k Log-Likelihood}
\usage{
mbgcnbd.cbs.LL(params, cal.cbs)

mbgcnbd.LL(params, x, t.x, T.cal, litt)

bgcnbd.cbs.LL(params, cal.cbs)

bgcnbd.LL(params, x, t.x, T.cal, litt)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{cal.cbs}{Calibration period customer-by-sufficient-statistic (CBS)
data.frame. It must contain a row for each customer, and columns \code{x}
for frequency, \code{t.x} for recency , \code{T.cal} for the total time
observed, as well as the sum over logarithmic intertransaction times
\code{litt}. A correct format can be easily generated based on the complete
event log of a customer cohort with \code{\link{elog2cbs}}.}

\item{x}{frequency, i.e. number of re-purchases}

\item{t.x}{recency, i.e. time elapsed from first purchase to last purchase}

\item{T.cal}{total time of observation period}

\item{litt}{sum of logarithmic interpurchase times}
}
\value{
For \code{bgcnbd.cbs.LL}, the total log-likelihood of the provided
  data. For \code{bgcnbd.LL}, a vector of log-likelihoods as long as the
  longest input vector (\code{x}, \code{t.x}, or \code{T.cal}).
}
\description{
Calculates the log-likelihood of the (M)BG/CNBD-k model.
}
\references{
(M)BG/CNBD-k: Reutterer, T., Platzer, M., & Schroeder, N. (2020).
  Leveraging purchase regularity for predicting customer behavior the easy
  way. International Journal of Research in Marketing.
  \doi{10.1016/j.ijresmar.2020.09.002}
}
