% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/93_density.R
\name{density.bvar}
\alias{density.bvar}
\alias{plot.bvar_density}
\alias{independent_index}
\title{Density methods for Bayesian VARs}
\usage{
\method{density}{bvar}(x, vars = NULL, vars_response = NULL, vars_impulse = NULL, ...)

\method{plot}{bvar_density}(x, mar = c(2, 2, 2, 0.5), mfrow = c(length(x), 1), ...)

independent_index(var, n_vars, lag)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{vars}{Character vector used to select variables. Elements are matched
to hyperparameters or coefficients. Coefficients may be matched based on
the dependent variable (by providing the name or position) or the
explanatory variables (by providing the name and the desired lag). See the
example section for a demonstration. Defaults to \code{NULL}, i.e. all
hyperparameters.}

\item{vars_response}{Optional character or integer vectors used
to select coefficents. Dependent variables are specified with
\emph{vars_response}, explanatory ones with \emph{vars_impulse}. See the
example section for a demonstration.}

\item{vars_impulse}{Optional character or integer vectors used
to select coefficents. Dependent variables are specified with
\emph{vars_response}, explanatory ones with \emph{vars_impulse}. See the
example section for a demonstration.}

\item{...}{Fed to \code{\link[stats]{density}} or
\code{\link[graphics]{par}}.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{mfrow}{Numeric vector. Rows for \code{\link[graphics]{par}}.}

\item{var, n_vars, lag}{Integer scalars. Retrieve the position of lag
\emph{lag} of variable \emph{var} given \emph{n_vars} total variables.}
}
\value{
Returns a list with outputs of \code{\link[stats]{density}}.
}
\description{
Calculates densities of hyperparameters or coefficient draws from Bayesian
VAR models generated via \code{\link{bvar}}. Wraps standard
\code{\link[stats]{density}} outputs into a \code{list}.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Get densities of the hyperparameters
density(x)

# Plot them
plot(density(x))

# Only get the densities associated with dependent variable 1
density(x, vars_response = "CPI")

# Check out the constant's densities
plot(density(x, vars_impulse = 1))

# Get the densities of variable three's first lag
density(x, vars = "FEDFUNDS-lag1")

# Get densities of lambda and the coefficients of dependent variable 2
density(x, vars = c("lambda", "UNRATE"))
}
}
\seealso{
\code{\link{bvar}}; \code{\link[stats]{density}}
}
\keyword{BVAR}
\keyword{analysis}
