% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bws_test.r
\name{bws_test}
\alias{bws_test}
\title{Perform the Baumgartner-Weiss-Schindler hypothesis test.}
\usage{
bws_test(x, y)
}
\arguments{
\item{x}{a vector of the first sample.}

\item{y}{a vector of the first sample.}
}
\value{
Object of class \code{htest}, a list of the test statistic,
the p-value, and the \code{method} noted.
}
\description{
Perform the Baumgartner-Weiss-Schindler hypothesis test.
}
\note{
Eventually this will support the one-sided tests of
Neuhauser and Murakami.
}
\examples{

# under the null
set.seed(123)
x <- rnorm(100)
y <- rnorm(100)
hval <- bws_test(x,y)

# under the alternative
set.seed(123)
x <- rnorm(100)
y <- rnorm(100,mean=0.5)
hval <- bws_test(x,y)

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
W. Baumgartner, P. Weiss, H. Schindler, 'A Nonparametric Test for the General Two-Sample Problem', 
Biometrics, Vol. 54, No. 3 (Sep., 1998), pp. 1129-1135. 
\url{http://doai.io/10.2307/2533862}
}
\seealso{
\code{\link{bws_test}}, \code{\link{bws_stat}}
}
\keyword{htest}

