% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class_definitions.R
\docType{class}
\name{NHPP-class}
\alias{NHPP-class}
\title{S4 class of model informations for non-homogeneous Poisson process}
\description{
Informations of NHPP with cumulative intensity function
\eqn{\Lambda(t, \xi)}.
}
\section{Slots}{

\describe{
\item{\code{xi}}{parameter \eqn{\xi}}

\item{\code{Lambda}}{function \eqn{\Lambda(t,\xi)}}

\item{\code{priorDensity}}{prior density function for \eqn{\xi}}

\item{\code{start}}{list of starting values for the Metropolis within Gibbs sampler}
}}
\examples{
parameter <- list(xi = c(2, 0.2))
Lambda <- function(t, xi) (t / xi[2])^xi[1]
priorDensity <- function(xi) dgamma(xi, c(2, 0.2), 1)
start <- parameter
model <- set.to.class("NHPP", parameter, start = start, Lambda = Lambda,
   priorDensity = priorDensity)
}

