% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/estimate.R
\docType{methods}
\name{estimate,mixedRegression-method}
\alias{estimate,mixedRegression-method}
\title{Estimation for the hierarchical (mixed) regression model}
\usage{
\S4method{estimate}{mixedRegression}(model.class, t, data, nMCMC, propSd,
  adapt = TRUE, proposal = c("normal", "lognormal"))
}
\arguments{
\item{model.class}{class of the hierarchical regression model including all required information, see \code{\link{mixedRegression-class}}}

\item{t}{list or vector of time points}

\item{data}{list or matrix of observation variables}

\item{nMCMC}{length of Markov chain}

\item{propSd}{vector of proposal variances for \eqn{\phi}}

\item{adapt}{if TRUE (default), proposal variance is adapted}

\item{proposal}{proposal density: "normal" (default) or "lognormal" (for positive parameters)}
}
\description{
Bayesian estimation of the parameter of the hierarchical regression model
  \eqn{y_{ij} = f(\phi_j, t_{ij}) + \epsilon_{ij}, \phi_j\sim N(\mu, \Omega),
  \epsilon_{ij}\sim N(0,\gamma^2\widetilde{s}(t_{ij}))}.
}
\examples{
mu <- c(10, 5); Omega <- c(0.9, 0.01)
phi <- cbind(rnorm(21, mu[1], sqrt(Omega[1])), rnorm(21, mu[2], sqrt(Omega[2])))
model <- set.to.class("mixedRegression",
                 parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 0.1),
                 fun = function(phi, t) phi[1]*t + phi[2], sT.fun = function(t) 1)
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, plot.series = FALSE)
est <- estimate(model, t, data[1:20,], 1000)
plot(est)
}
\references{
Hermann, S., K. Ickstadt, and C. H. Mueller (2016).
Bayesian Prediction of Crack Growth Based on a Hierarchical Diffusion Model.
Applied Stochastic Models in Business and Industry, DOI: 10.1002/asmb.2175.
}

