% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{class}
\name{Organism-class}
\alias{Organism-class}
\title{Structure of the S4 class "Organism"}
\description{
Structure of the S4 class \code{Organism} representing the organisms present in the environment.
}
\section{Slots}{

\describe{
\item{\code{lbnd}}{A numeric vector containing the lower bounds of the model structure.}

\item{\code{ubnd}}{A numeric vector containing the upper bounds of the model structure.}

\item{\code{type}}{A character vector containing the description of the organism.}

\item{\code{medium}}{A character vector containing all exchange reactions of the organism.}

\item{\code{lpobj}}{A sybil optimization object containing the linear programing problem.}

\item{\code{fbasol}}{A list with the solutions of the flux balance analysis.}

\item{\code{lyse}}{A boolean variable indicating if the organism should lyse after death.}

\item{\code{feat}}{A list containing conditional features for the object (contains at the momement only biomass components for lysis).}

\item{\code{deathrate}}{A numeric value giving the factor by which the growth should be reduced in every iteration (unit: fg)}

\item{\code{growthlimit}}{A numeric value giving the growth limit at which the organism dies.}

\item{\code{growtype}}{A character vector giving the functional type for growth (linear or exponential).}

\item{\code{kinetics}}{A List containing Km and v_max values for each reactions.}

\item{\code{speed}}{A integer vector representing the speed by which bacterium is moving (given by cell per iteration).}

\item{\code{cellarea}}{A numeric value indicating the surface that one organism occupies (unit: mu cm^2)}

\item{\code{cellweight}}{A numeric value giving the maximal dry weight of single organism (unit: fg)}
}}

