% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawNBAcourt.R
\name{drawNBAcourt}
\alias{drawNBAcourt}
\title{Add lines of NBA court to an existing ggplot2 plot}
\usage{
drawNBAcourt(p, size = 1.5, col = "black", full = FALSE)
}
\arguments{
\item{p}{a ggplot2 object.}

\item{size}{numeric, line size.}

\item{col}{line color.}

\item{full}{logical; if TRUE draws a complete NBA court; if FALSE draws a half court.}
}
\value{
A ggplot2 object
}
\description{
Add lines of NBA court to an existing ggplot2 plot
}
\examples{
library(ggplot2)
p <- ggplot(data.frame(x=0, y=0), aes(x,y)) + coord_fixed()
drawNBAcourt(p)
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketballanalyzer.help@unibs.it})
}
