% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_Ibov_Stocks.R
\name{GetIbovStocks}
\alias{GetIbovStocks}
\title{Function to download the current components of the Ibovespa index from Bovespa website}
\usage{
GetIbovStocks(do.cache = TRUE, cache.folder = "BGS_Cache", max.tries = 10)
}
\arguments{
\item{do.cache}{Use caching system? (default = TRUE)}

\item{cache.folder}{Where to save cache files? (default = 'BGS_Cache')}

\item{max.tries}{Maximum number of attempts to download the data}
}
\value{
A dataframe that includes a column with the list of tickers of companies that belong to the Ibovespa index
}
\description{
This function scrapes the stocks that constitute the Ibovespa index from the wikipedia page at http://bvmf.bmfbovespa.com.br/indices/ResumoCarteiraTeorica.aspx?Indice=IBOV&idioma=pt-br.
}
\examples{
\dontrun{
df.ibov <- GetIbovStocks()
print(df.ibov$tickers)
}
}
