% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgeC14_Computation.R
\name{AgeC14_Computation}
\alias{AgeC14_Computation}
\title{Bayesian analysis for C-14 age estimations of various samples}
\usage{
AgeC14_Computation(Data_C14Cal, Data_SigmaC14Cal, SampleNames, Nb_sample,
  PriorAge = rep(c(10, 50), Nb_sample), SavePdf = FALSE,
  OutputFileName = c("MCMCplot", "HPD_CalC-14Curve", "summary"),
  OutputFilePath = c(""), SaveEstimates = FALSE,
  OutputTableName = c("DATA"), OutputTablePath = c(""),
  StratiConstraints = c(), sepSC = c(","), Model = c("full"),
  CalibrationCurve = c("AtmosphericNorth"), Iter = 50000, t = 5,
  n.chains = 3, quiet = FALSE)
}
\arguments{
\item{Data_C14Cal}{\link{numeric} (\strong{required}): corresponding to C-14 age estimate.}

\item{Data_SigmaC14Cal}{\link{numeric} (\strong{required}): correponding to the error of C-14 age estimates.}

\item{SampleNames}{\link{character} (\strong{required}): names of sample. The length of this vector is equal to \code{Nb_sample}.}

\item{Nb_sample}{\link{integer}: number of samples.}

\item{PriorAge}{\link{numeric} (with default): lower and upper bounds for age parameter of each sample in years (not in ka).
Note that, \code{length(PriorAge) == 2 * Nb_sample}
and \code{PriorAge[2i-1,2i]} correponds to the lower and upper bounds of sample whose number ID is equal to \code{i}.}

\item{SavePdf}{\link{logical} (with default): if TRUE save graphs in pdf file named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputFileName}{\link{character} (with default): name of the pdf file that will be generated by the function if \code{SavePd=TRUE},
\code{length(OutputFileName)===3}, see \bold{PLOT OUTPUT} in \bold{Value} section for more informations.}

\item{OutputFilePath}{\link{character} (with default): path to the pdf file that will be generated by the function if \code{SavePdf=TRUE}.
If it is not equal to "", it must be terminated by "/".}

\item{SaveEstimates}{\link{logical} (with default): if TRUE save Bayes estimates, credible interval at level 68\% and 95\% and
the result of the gelman en Rubin test of convergency, in a csv table named \code{OutputFileName} in folder \code{OutputFilePath}.}

\item{OutputTableName}{\link{logical} (with default): name of the table that will be generated by the function if \code{SaveEstimates=TRUE}.}

\item{OutputTablePath}{character (with default): path to the table that will be generated by the function if \code{SaveEstimates=TRUE}.
If it is not equal to "", it must be terminated by "/".}

\item{StratiConstraints}{\link{numeric} matrix or character(with default): input object for the statigraphic relation between samples.
If there is stratigraphic relation between samples see the details section for instructions regarding how to correctly fill \code{StratiConstraints};
the user can refer to a matrix (numeric matrix) or to a csv file (character).
If there is no stratigraphic relation default value is suitable.}

\item{sepSC}{\link{character} (with default): if \code{StratiConstraints} is character,
indicate column separator in \code{StratiConstraints} csv file.}

\item{Model}{\link{character} (with default): if \bold{"full"}, error on estimate calibration curve is taken account.
If \bold{"naive"} this error is not taken account in the age estimate.}

\item{CalibrationCurve}{\link{character} (with default): calibration curve choosen. Allowed inputs are
\itemize{
\item \bold{"AtmosphericNorth"} for Northern Hemisphere atmospheric radiocarbon calibration curve,
\item \bold{"Marine"} for Marine radiocarbon calibration curve,
\item \bold{"AtmosphericSouth"} for Southern Hemisphere atmospheric radiocarbon calibration curve
\item \bold{a csv file, with tree columns, the first column is dedicated to "Cal.BP", the second to "XC-14.age", the third to "Error".
The decimal of this file must be a dot, and the separator must be a comma. }
}}

\item{Iter}{\link{integer} (with default): number of iterations for the MCMC computation (for more information see \link[rjags:jags.model]{rjags::jags.model}).}

\item{t}{integer (with default): 1 every \code{t} iterations of the MCMC is considered for sampling the posterior distribution
(for more information see \link[rjags:jags.model]{rjags::jags.model}.}

\item{n.chains}{\link{integer} (with default): number of independent chains for the model (for more information see \link[rjags:jags.model]{rjags::jags.model}.}

\item{quiet}{\link{logical} (with default): enables/disables \link{rjags} messages}
}
\value{
\bold{NUMERICAL OUTPUT}

\enumerate{
\item \bold{A list containing the following objects:}
\itemize{
\item \bold{Sampling}: that corresponds to a sample of the posterior distributions of the age parameters;
\item \bold{Outlier}: stating the names of samples that are considered as outliers;
\item \bold{Model}: stating which model was chosen (\code{"full"} or \code{"naive"});
\item \bold{CalibrationCurve}: stating which radiocarbon calibration curve was chosen;
\item \bold{PriorAge}: stating the priors used for the age parameter;
\item \bold{StratiConstraints}: stating the stratigraphic relations between samples considered in the model.
}
\item\bold{The Gelman and Rubin test of convergency}: print the result of the Gelman and Rubin test of convergency for the age estimate for each sample.
A result close to one is expected.\cr
In addition, the user must visually assess the convergency of the trajectories by looking at the graph
generated by the function (see \bold{PLOT OUTPUT} for more informations).\cr
If both convergencies (Gelman and Rubin test and plot checking) are satisfactory,
the user can consider the estimates as valid.
Otherwise, the user may try increasing the number of MCMC interations (\code{Iter})
or being more precise if it is possible on the \code{PriorAge} parameter to reach convergency.
\item \bold{Credible intervals and Bayes estimates}: prints the Bayes estimates, the credible intervals at 95\% and 68\% for
the age parameters for each sample.
}

\bold{PLOT OUTPUT}

\enumerate{
\item\bold{MCMC trajectories}: A graph with the MCMC trajectories and posterior distributions of the age parameter is displayed. \cr
On each line, the plot on the left represents the MCMC trajectories, and the one on the right the posterior distribution of the parameter.
\item \bold{Summary of sample age estimates}: plot credible intervals and Bayes estimate of each sample age on one graph.
}

To give the results in a publication, we recommend to give the Bayes estimate of the parameters as well as the credible interval at 95\% or 68\%.
}
\description{
This function calibrates the C-14 age of samples to get an age (in ka).
The user can choose one of the following radiocarbon calibration curve:
Northern or Sourthen Hemisphere or marine atmospheric. It must be the same curve for all samples.
}
\note{
Please note that the initial values for all MCMC are currently all the same for all chains since we rely on the automatic
initial value generation of JAGS. This is not optimal and will be changed in future. However, it does not affect the quality
of the age estimates if the chains have converged.
}
\examples{
## Load data
data(DATA_C14,envir = environment())
C14Cal <- DATA_C14$C14[,1]
SigmaC14Cal <- DATA_C14$C14[,2]
Names <- DATA_C14$Names
nb_sample <- length(Names)

## Age computation of samples without stratigraphic relations
Age <- AgeC14_Computation(
 Data_C14Cal = C14Cal,
 Data_SigmaC14Cal = SigmaC14Cal,
 SampleNames = Names,
 Nb_sample = nb_sample,
 PriorAge = rep(c(20,60),nb_sample),
 Iter = 500,
 quiet = TRUE)

}
\references{
Christen, JA (1994). Summarizing a set of radiocarbon determinations: a robust approach. Applied Statistics, 489-503.

Reimer PJ, Bard E, Bayliss A, Beck JW, Blackwell PC, Bronl Ramsey C, Buck CE, Cheng H, Edwards RL, Friedrich M,
Grootes PM, Guilderson TP, Haflidason H, Hajdas I, Hatte C, Heaton TJ, Hoffmann DL, Hogg AG, Hughen KA, Kaiser KF, Kromer B,
Manning SW, Niu M, Reimer RW, Richards DA, Scott EM, Southon JR, Staff RA, Turney CSM, van der Plicht J. 2013.
IntCal13 ans Marine13 radiocarbon age calibration curves 0-50000 years cal BP. Radiocarbon 55(4)=1869-1887.

Hogg AG, Hua Q, Blackwell PG, Niu M, Buck CE, Guilderson TP, Heaton TJ, Palmer JG, Reimer PJ, Reimer RW, Turney CSM, Zimmerman SRH.
2013. SHCal13 Southern Hemisphere calibration, 0-50000 years cal BP. Radiocarbon 55(4):1889-1903
}
\seealso{
\link{rjags}, \link{plot_MCMC}, \link{SCMatrix}, \link{plot_Ages}
}
\author{
Claire Christophe, Anne Philippe, Guillaume Guérin, Sebastian Kreutzer
}
