% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdissplot.R
\name{ggdissplot}
\alias{ggdissplot}
\title{Dissolution Data Plot}
\usage{
ggdissplot(dis_data, show.mean = FALSE, show.SD = FALSE)
}
\arguments{
\item{dis_data}{A data frame containing the dissolution data. The first column of the data frame should denote
the group labels identifying whether a given dissolution belongs to the "reference" or "test" formulation group.
For a given dissolution run, the remaining columns of the data frame contains the individual run's dissolution
measurements sorted in time. Alternatively, the user may provide a data object of class dis_data containing the
dissolution data. See the \code{make_dis_data()} function for the particular structure of the data object.}

\item{show.mean}{logical; if \code{TRUE}, plot the connected mean dissolution values for each group.}

\item{show.SD}{logical; if \code{TRUE}, calculate the variance of the dissolution data at each time point for each group. The values are placed at the top of the plot over the corresponding time point.}
}
\value{
The function returns a plot of the dissolution data.
}
\description{
Minimalist ggplot function for plotting dissolution data sets.
}
\examples{
### dis_data comes loaded with the package
ggdissplot(dis_data)

}
