% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_spec_coveff.R
\name{edit_spec_coveff}
\alias{edit_spec_coveff}
\alias{build_spec_coveff_one_variable}
\alias{replace_spec_coveff}
\title{Customize specifications for covariate effect simulations/visualizations}
\usage{
build_spec_coveff_one_variable(
  var_name,
  values_vec,
  qi_width_cov = 0.9,
  n_sigfig = 3,
  use_seps = TRUE,
  drop_trailing_dec_mark = TRUE,
  show_ref_value = TRUE
)

replace_spec_coveff(spec_orig, spec_new, replace_ref_value = FALSE)
}
\arguments{
\item{var_name}{The name of the variable for which a new spec is to be
created.}

\item{values_vec}{The vector of the values for creating a new spec.}

\item{qi_width_cov}{the width of the quantile interval for continuous
covariates in the forest plot. Default is 0.9 (i.e. visualize effect of
covariate effect at their 5th and 95th percentile values).}

\item{n_sigfig}{Number of significant figures to form value_label of
continuous variables. See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}} for details.}

\item{use_seps}{Whether to use separators for thousands in printing numbers.
See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}} for details.}

\item{drop_trailing_dec_mark}{Whether to drop the trailing decimal mark
(".") in value_label of continuous variables. See \code{\link[gt:vec_fmt_number]{gt::vec_fmt_number()}}
for details.}

\item{show_ref_value}{Whether to show the reference value in the plot and
table. Setting this results in the \code{show_ref_value} column in the
specification data frame.}

\item{spec_orig}{Original specification data frame.}

\item{spec_new}{New specification data frame. It can be generated by
\code{\link[=build_spec_coveff_one_variable]{build_spec_coveff_one_variable()}} or manually crafting with the
following variables: \code{var_name}, \code{var_label}, \code{value_order}, \code{value_annot},
\code{value_label}, \code{value_cont} or \code{value_cat}, \code{is_ref_value},
\code{show_ref_value}. You can have multiple variables stacked together.}

\item{replace_ref_value}{Whether to replace the reference values from the
original specification data frame. Default is FALSE; in this case,
show_ref_value is set to FALSE as it can be confusing.
If you set replace_ref_value to TRUE,
the reference calculation for the forest plot is also done with the one
in spec_new.}
}
\value{
See \code{\link[=build_spec_coveff]{build_spec_coveff()}} for the structure of the return object.
\code{\link[=build_spec_coveff_one_variable]{build_spec_coveff_one_variable()}} returns a data frame corresponding to
the specification for a single variable, which can be used as an input to
\code{\link[=replace_spec_coveff]{replace_spec_coveff()}}.
}
\description{
\itemize{
\item \code{\link[=build_spec_coveff_one_variable]{build_spec_coveff_one_variable()}} is a helper function to create a new
specification for a single variable. This is useful when you want to
customize the specification for a single variable.
\item \code{\link[=replace_spec_coveff]{replace_spec_coveff()}} is used to replace the specification for some (or
all) variables in the original specification data frame. If you want to
replace multiple variables, you can just stack the specifications
together.
}
}
\examples{
set.seed(1234)
data(d_sim_binom_cov_hgly2)

ermod_bin <- suppressWarnings(dev_ermod_bin(
  data = d_sim_binom_cov_hgly2, var_resp = "AEFLAG",
  var_exposure = "AUCss_1000", var_cov = c("BGLUC", "RACE"),
  verbosity_level = 0,
  # Below option to make the example run fast
  chains = 2, iter = 1000
))

spec_coveff <- build_spec_coveff(ermod_bin)
spec_new_bgluc <- build_spec_coveff_one_variable(
  "BGLUC", seq(4, 8, by = 0.1),
  qi_width_cov = 0.8, show_ref_value = FALSE
)
spec_coveff_new <- replace_spec_coveff(spec_coveff, spec_new_bgluc)
plot_coveff(ermod_bin, spec_coveff = spec_coveff_new)

}
