% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.befa.R
\name{summary.befa}
\alias{summary.befa}
\title{Summarize 'befa' object}
\usage{
\method{summary}{befa}(object, ...)
}
\arguments{
\item{object}{Object of class 'befa'.}

\item{...}{The following extra arguments can be specified:
\itemize{
  \item \code{what}: How to summarize the posterior distribution?
        \itemize{
          \item \code{what = 'maxp'} (default): Only factor loadings with
                highest posterior probability of being different from zero or
                discarded from the model (if \code{dedic = 0}) are
                summarized.
          \item \code{what = 'all'}: All factor loadings with corresponding
                posterior probability to be allocated to a given factor (or
                to be discarded from the model) larger than \code{min.prob}
                are summarized.
          \item \code{what = 'hppm'}: Highest posterior probability models
                with probability larger than \code{min.prob} are summarized.
        }
  \item \code{byfac}: Sort factor loadings by factors if \code{TRUE},
        otherwise by manifest variables if \code{FALSE} (default).
  \item \code{hpd.prob}: Probability used to compute the highest posterior
        density intervals of the posterior distribution of the model
        parameters (default: 0.95).
  \item \code{min.prob}: If \code{what = 'all'}, only factor loadings with
        posterior probability of being dedicated to a given factor (or
        discarded from the model) larger than this value are displayed.
        If \code{what = 'hppm'}, only highest posterior probability models
        with probability larger than this value are displayed. (default:
        0.20)
}}
}
\value{
If called directly, the summary is formatted and displayed on the
standard output. Otherwise if saved in an object, a list of the following
elements is returned:
\itemize{
 \item \code{MHacc}: Metropolis-Hastings acceptance rate.
 \item \code{alpha}: Data frame (or list of data frames if
       \code{what = 'hppm'}) containing posterior summary statistics for the
       factor loadings.
 \item \code{sigma}: Data frame (or list of matrices if \code{what = 'hppm'})
       containing posterior summary statistics for the idiosyncratic
       variances.
 \item \code{R}: Data frame (or list of data frames if \code{what = 'hppm'})
       containing posterior summary statistics for the factor correlations.
 \item \code{beta}: Data frame (or list of data frames if
       \code{what = 'hppm'}) containing posterior summary statistics for the
       regression coefficients (if any).
 \item \code{nfac} (only if \code{what = 'maxp'} or \code{what = 'all'}):
       Table of posterior frequencies of numbers of factors.
 \item \code{hppm} (only if \code{what = 'hppm'}): List of the following
       elements summarizing the different HPP models, sorted in decreasing
       order of their posterior probabilities:
       \itemize{
         \item \code{prob}: Vector of posterior probabilities.
         \item \code{nfac}: Vector of numbers of factors.
         \item \code{dedic}: Data frame of factor indicators.
       }
}
Data frames of posterior summary statistics include the means (\code{mean}),
standard deviations (\code{sd}) and highest posterior density intervals
(\code{hpd.lo} and \code{hpd.up}, for the probability specified in
\code{hpd.prob}) of the corresponding parameters.

For the factor loadings, the matrix may also include a column labeled
'\code{dedic}' indicating to which factors the corresponding manifest
variables are dedicated (a zero value means that the manifest variable does
not load on any factor), as well as a column labeled '\code{prob}' showing
the corresponding posterior probabilities that the manifest variables load on
these factors.

Summary results are returned as lists of data frames for HPP models, where
the elements of the list are labeled as '\code{m1}, '\code{m2}', etc.
}
\description{
Generic function summarizing the posterior results of a 'befa' object.
Optional arguments can be specified to customize the summary.
}
\details{
This function summarizes the posterior distribution of the parameters.
The algorithm may visit different configurations of the indicator matrix
\eqn{\Delta} during sampling, where the manifest variables are allocated to
different latent factors. When the posterior distribution of the factor
loadings is summarized separately for each manifest variable
(\code{what = 'maxp'} or \code{what = 'all'}), the function provides the
latent factors each manifest variable is allocated to (\code{dedic}), and the
corresponding posterior probability (\code{prob}).
Low probability cases can be discarded by setting \code{min.prob}
appropriately (default is 0.20).

Idiosyncratic variances, factor correlation matrix and regression
coefficients (if any) are summarized across all MCMC iterations if
\code{what = 'all'} or \code{what = 'maxp'}, and within each HPP model if
\code{what = 'hppm'}.

\strong{Highest posterior probability model.}
The HPP model is the model with a given allocation of the measurements to the
latent factors (i.e., a given indicator matrix \eqn{\Delta}) that is visited
most often by the algorithm.

When specifying \code{what = 'hppm'}, the function sorts the models according
to the posterior frequencies of their indicator matrices in decreasing order.
Therefore, the first model returned (labeled 'm1') corresponds to the HPP
model.
Low probability models can be discarded by setting \code{min.prob}
appropriately(default is 0.20, implying that only models with a posterior
probability larger than 0.20 are displayed).

HPP models can only be found if identification with respect to column
switching has been restored \emph{a posteriori}. An error message is returned
if this is not the case.
}
\examples{
set.seed(6)

# generate fake data with 15 manifest variables and 3 factors
Y <- simul.dedic.facmod(N = 200, dedic = rep(1:3, each = 5))

# run MCMC sampler and post process output
# notice: 1000 MCMC iterations for illustration purposes only,
#  increase this number to obtain reliable posterior results!
mcmc <- befa(Y, Kmax = 5, iter = 1000)
mcmc <- post.column.switch(mcmc)
mcmc <- post.sign.switch(mcmc)

# summarize posterior results
summary(mcmc)

# summarize highest posterior probability (HPP) model
hppm.sum <- summary(mcmc, what = 'hppm')

# print summary with 6-digit precision
print(hppm.sum, digits = 6)

# extract posterior means of the factor loadings in HPP model
alpha.mean <- hppm.sum$alpha$m1$mean
print(alpha.mean)

}
\author{
Rémi Piatek \email{remi.piatek@econ.ku.dk}
}
\seealso{
\code{\link{plot.befa}} to plot posterior results.
}

