# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get the distances for computing the partition function given
#' the cardinalities.
#'
#' @param n The number of items.
#' @param cardinalities Number of times each distance appears.
#' @param metric A string. Available options are \code{"footrule"},
#' and \code{"spearman"}. Defaults to \code{"footrule"}.
#' @return A scalar, the logarithm of the partition function.
#' @keywords internal
#'
get_summation_distances <- function(n, cardinalities, metric = "footrule") {
    .Call(`_BayesMallows_get_summation_distances`, n, cardinalities, metric)
}

#' Compute the distance between two rank vectors.
#'
#' @param r1 A vector of ranks.
#' @param r2 A vector of ranks.
#' @param metric A string. Available options are \code{"footrule"},
#' \code{"kendall"}, \code{"cayley"}, \code{"hamming"}, and \code{"spearman"}.
#' Defaults to \code{"footrule"}.
#' @return A scalar.
#' @details Note that the Spearman distance is the squared L2 norm, whereas
#' the footrule distance is the L1 norm.
#' @keywords internal
#'
get_rank_distance <- function(r1, r2, metric = "footrule") {
    .Call(`_BayesMallows_get_rank_distance`, r1, r2, metric)
}

#' Compute importance sampling estimates of log partition function
#' for footrule and Spearman distances.
#'
#' @param alpha_vector Vector of alpha values at which to compute partition function.
#' @param n_items Integer specifying the number of ranked items.
#' @param metric Distance measure of the target Mallows distribution. Defaults to \code{footrule}.
#' @param nmc Number of Monte Carlo samples. Defaults to \code{1e4}.
#'
#' @keywords internal
#'
compute_importance_sampling_estimate <- function(alpha_vector, n_items, metric = "footrule", nmc = 1e4L) {
    .Call(`_BayesMallows_compute_importance_sampling_estimate`, alpha_vector, n_items, metric, nmc)
}

factorial <- function(n) {
    .Call(`_BayesMallows_factorial`, n)
}

binomial_coefficient <- function(n, k) {
    .Call(`_BayesMallows_binomial_coefficient`, n, k)
}

std_setdiff <- function(x, y) {
    .Call(`_BayesMallows_std_setdiff`, x, y)
}

sample_int <- function(probs) {
    .Call(`_BayesMallows_sample_int`, probs)
}

#' Compute the logarithm of the partition function for a Mallows rank model.
#'
#' @param n_items Number of items.
#' @param alpha The value of the alpha parameter.
#' @param cardinalities Number of occurrences for each unique distance.
#' Applicable for footrule and Spearman distance. Defaults to \code{R_NilValue}.
#' @param logz_estimate Precomputed importance sampling fit.
#' @param metric A string. Available options are \code{"footrule"},
#' \code{"kendall"}, \code{"spearman"}, \code{"cayley"}, and \code{"hamming"}.
#' Defaults to \code{"footrule"}.
#' @return A scalar, the logarithm of the partition function.
#' @keywords internal
#'
get_partition_function <- function(n_items, alpha, cardinalities = NULL, logz_estimate = NULL, metric = "footrule") {
    .Call(`_BayesMallows_get_partition_function`, n_items, alpha, cardinalities, logz_estimate, metric)
}

#' Asymptotic Approximation of Partition Function
#'
#' Compute the asymptotic approximation of the logarithm of the partition function,
#' using the iteration algorithm of \insertCite{mukherjee2016;textual}{BayesMallows}.
#'
#' @param alpha_vector A numeric vector of alpha values.
#' @param n_items Integer specifying the number of items.
#' @param metric One of \code{"footrule"} and \code{"spearman"}.
#' @param K Integer.
#' @param n_iterations Integer specifying the number of iterations.
#'
#' @return A vector, containing the partition function at each value of alpha.
#' @keywords internal
#'
#' @references \insertAllCited{}
#'
asymptotic_partition_function <- function(alpha_vector, n_items, metric, K, n_iterations) {
    .Call(`_BayesMallows_asymptotic_partition_function`, alpha_vector, n_items, metric, K, n_iterations)
}

#' Sample from the Mallows distribution.
#'
#' Sample from the Mallows distribution with arbitrary distance metric using
#' a Metropolis-Hastings algorithm.
#'
#' @param rho0 Vector specifying the latent consensus ranking.
#' @param alpha0 Scalar specifying the scale parameter.
#' @param n_samples Integer specifying the number of random samples to generate.
#' @param burnin Integer specifying the number of iterations to discard as burn-in.
#' @param thinning Integer specifying the number of MCMC iterations to perform
#' between each time a random rank vector is sampled.
#' @param leap_size Integer specifying the step size of the leap-and-shift proposal distribution.
#' @param metric Character string specifying the distance measure to use. Available
#' options are \code{"footrule"} (default), \code{"spearman"}, \code{"cayley"}, \code{"hamming"}, and
#' \code{"kendall"}. For sampling from the Mallows model with Cayley, Hamming, Kendall,
#' and Ulam distances
#' the \code{PerMallows} package \insertCite{irurozki2016}{BayesMallows} can also be used.
#'
#' @keywords internal
#'
#' @references \insertAllCited{}
#'
rmallows <- function(rho0, alpha0, n_samples, burnin, thinning, leap_size = 1L, metric = "footrule") {
    .Call(`_BayesMallows_rmallows`, rho0, alpha0, n_samples, burnin, thinning, leap_size, metric)
}

#' Worker function for computing the posterior distribution.
#'
#' @param rankings A set of complete rankings, with one sample per column.
#' With n_assessors samples and n_items items, rankings is n_items x n_assessors.
#' @param nmc Number of Monte Carlo samples.
#' @param constraints List of lists of lists, returned from `generate_constraints`.
#' @param cardinalities Used when metric equals \code{"footrule"} or
#' \code{"spearman"} for computing the partition function. Defaults to
#' \code{R_NilValue}.
#' @param logz_estimate Estimate of the log partition function.
#' @param metric The distance metric to use. One of \code{"spearman"},
#' \code{"footrule"}, \code{"kendall"}, \code{"cayley"}, or
#' \code{"hamming"}.
#' @param n_clusters Number of clusters. Defaults to 1.
#' @param include_wcd Boolean defining whether or
#' not to store the within-cluster distance.
#' @param leap_size Leap-and-shift step size.
#' @param alpha_prop_sd Standard deviation of proposal distribution for alpha.
#' @param alpha_init Initial value of alpha.
#' @param alpha_jump How many times should we sample \code{rho} between
#' each time we sample \code{alpha}. Setting \code{alpha_jump} to a high
#' number can significantly speed up computation time, since we then do not
#' have to do expensive computation of the partition function.
#' @param lambda Parameter of the prior distribution.
#' @param psi Hyperparameter for the Dirichlet prior distribution used in clustering.
#' @param rho_thinning Thinning parameter. Keep only every \code{rho_thinning} rank
#' sample from the posterior distribution.
#' @param aug_thinning Integer specifying the thinning for data augmentation.
#' @param clus_thin Integer specifying the thinning for saving cluster assignments.
#' @param save_aug Whether or not to save the augmented data every
#' \code{aug_thinning}th iteration.
#' @param verbose Logical specifying whether to print out the progress of the
#' Metropolis-Hastings algorithm. If \code{TRUE}, a notification is printed every
#' 1000th iteration.
#' @keywords internal
#'
run_mcmc <- function(rankings, nmc, constraints, cardinalities, logz_estimate, rho_init, metric = "footrule", n_clusters = 1L, include_wcd = FALSE, leap_size = 1L, alpha_prop_sd = 0.5, alpha_init = 5, alpha_jump = 1L, lambda = 0.1, psi = 10L, rho_thinning = 1L, aug_thinning = 1L, clus_thin = 1L, save_aug = FALSE, verbose = FALSE) {
    .Call(`_BayesMallows_run_mcmc`, rankings, nmc, constraints, cardinalities, logz_estimate, rho_init, metric, n_clusters, include_wcd, leap_size, alpha_prop_sd, alpha_init, alpha_jump, lambda, psi, rho_thinning, aug_thinning, clus_thin, save_aug, verbose)
}

