% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_conversion.R
\name{rank_conversion}
\alias{rank_conversion}
\alias{create_ranking}
\alias{create_ordering}
\title{Convert between ranking and ordering.}
\usage{
create_ranking(orderings)

create_ordering(rankings)
}
\arguments{
\item{orderings}{A vector or matrix of ordered items. If a matrix, it should be of
size N times n, where N is the number of samples and n is the number of
items.}

\item{rankings}{A vector or matrix of ranked items. If a matrix, it should be N
times n, where N is the number of samples and n is the number of items.}
}
\value{
A vector or matrix of rankings. Missing orderings coded as \code{NA} are propagated into corresponding missing ranks and vice versa.
}
\description{
\code{create_ranking} takes a vector or matrix of ordered items \code{orderings} and
returns a corresponding vector or matrix of ranked items.
\code{create_ordering} takes a vector or matrix of rankings \code{rankings} and
returns a corresponding vector or matrix of ordered items.
}
\section{Functions}{
\itemize{
\item \code{create_ranking()}: Convert from ordering to ranking.

\item \code{create_ordering()}: Convert from ranking to ordering.

}}
\examples{
# A vector of ordered items.
orderings <- c(5, 1, 2, 4, 3)
# Get ranks
rankings <- create_ranking(orderings)
# rankings is c(2, 3, 5, 4, 1)
# Finally we convert it backed to an ordering.
orderings_2 <- create_ordering(rankings)
# Confirm that we get back what we had
all.equal(orderings, orderings_2)

# Next, we have a matrix with N = 19 samples
# and n = 4 items
set.seed(21)
N <- 10
n <- 4
orderings <- t(replicate(N, sample.int(n)))
# Convert the ordering to ranking
rankings <- create_ranking(orderings)
# Now we try to convert it back to an ordering.
orderings_2 <- create_ordering(rankings)
# Confirm that we get back what we had
all.equal(orderings, orderings_2)
}
