% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_SFM_poisson.R
\name{gibbs_SFM_poisson}
\alias{gibbs_SFM_poisson}
\title{Bayesian estimation of a mixture of shifted Poisson distributions.}
\usage{
gibbs_SFM_poisson(y, K, nb_iter, priors = list(), printing = TRUE)
}
\arguments{
\item{y}{Vector of discrete observations.}

\item{K}{Maximum number of mixture components.}

\item{nb_iter}{Number of MCMC iterations.}

\item{priors}{List of priors. Default is :
list(a0 = 1, A0 = 200, l0 = 1.1, L0 = 1.1/median(y))}

\item{printing}{Print intermediate output of the MCMC estimation ? default = TRUE.}
}
\value{
mcmc_draws : Parameter draws from the posterior distribution at each MCMC iteration. A (nb_iter x 2K + 1) matrix.
}
\description{
MCMC estimation using a sparse finite mixture (SFM) algorithm.
}
\references{
\insertRef{malsiner-walli_model-based_2016}{BayesMultiMode}\cr\cr
\insertRef{SFS:Mal:2019}{BayesMultiMode}
}
\keyword{internal}
