% Generated by roxygen2 (4.0.0): do not edit by hand
\name{Networks.STD}
\alias{Networks.STD}
\title{Bayesian Network Discovery using a Standard MCMC Algorithm}
\description{
This function implements the standard Markov chain Monte Carlo (MCMC) algorithm to perform feature selection and sub-network discovery using a Bayesian nonparametric model based on the Dirichlet process mixture (DPM) model and the Ising model.  
}

\usage{
Networks.STD(pvalue, net, iter = 5000, nburns = 2000, 
piall = c(0.75, 0.8, 0.85, 0.9), rhoall = c(0.5, 1, 5, 10, 15),
trace=TRUE,show.steps=1)
}
\arguments{
\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}

\item{net}{an "n" by "n" binary adjacent matrix (0/1) for the network configuration with n=length(pvalue)}

\item{iter}{the number of iterations; the default is 5000}

\item{nburns}{the number of burn-in; the default is 2000}

\item{piall}{a vector of possible choices for "pi0" in an increasing order; the default value is c(0.75, 0.8, 0.85, 0.9)}

\item{rhoall}{a vector of possible choices of "rho0" and "rho1" in an increasing order; the default value is c(0.5, 1, 5, 10, 15)}
\item{trace}{a logical variable indicating whether this run showing the results of iterations (\code{TRUE}), or not (\code{FALSE}), the default setting is \code{TRUE}}
\item{show.steps}{integer representing the frequency of the results of iterations presented, the defualt value is 1.The setting is invalid when \code{trace=FALSE}. The setting would not affect the data saved, only for printing}
}
\value{
a matrix of dimention (iter-nburns) by length(pvalue) containing posterior samples of classification label "g_i"
}
\details{
This function implements a Bayesian nonparametric mixture model for feature selection incorporating network information (Zhao et al., 2014):
\itemize{
\item  r_i| g_i, \strong{theta} ~ N(mu_{g_i}, sigma_{g_i}),
\item	g_i | z_i=k, \strong{q}_k ~ Discrete(\strong{a}_k, \strong{q}_k),
\item	\strong{theta} ~ G_{0k}, for g in \strong{a}_k,
\item	\strong{q}_k ~ Dirichlet(tau_k \strong{1}_{\{L_k\}}/L_k),
\item	\strong{theta}=\{{\strong{theta}_g}\}_{\{g in \strong{a}_0 and \strong{a}_1\}}
\item	\strong{theta}_g=(mu_g, sigma_g)
}
where we define
\describe{
\item{Index}{\strong{a}_0=(-L_0+1,-L_0+2,...,0) , \strong{a}_1=(1,2,...,L_1) and the correspondent probability q_0=(q_{-L_0+1}, q_{-L_0+2}, ...,q_0), q_1=(q_1, q_2, ..., q_{L_1}), according to the defination of Discrete(\strong{a}_k, \strong{b}_k), for example, Pr(g_i={L_0+2})=q_{-L_0+2}. }
\item{Assumption}{In this algorithm, we assume that "important" features should have larger statiscs comparing to "unimportant" ones without the loss of generality. In this regard, we set the restriction mu_g<mu_{g+1} for g=-L_0+1, -L_0+2,...,L_1.}
}
This function implements the NET-DPM-1 Zhat et al.(2014). Please refer to the Appnendix B.1 for more details. 
}
\examples{
#' ##Creating the network of 10X10 image
library(igraph)
library(BayesNetDiscovery)
g <- graph.lattice(length=10,dim=2)
net=as(get.adjacency(g,attr=NULL),"matrix")##this is the input of argument \\code{net}
##Assign the signal elements with signal intenstion 
##as normal distribution N(1,0.2). While noise is set as N(0,0.2)
newz=rep(0,100)
for (i in 3:7)
{
 newz[(i*10+3):(i*10+7)]=1
}
testcov<-0
for(i in 1:100){
 if(newz[i]==0){
   testcov[i]<-rnorm(1,mean=0,sd=0.2)

 }else{
  testcov[i]<-rnorm(1,mean=1,sd=0.2)

 }
}
##The profile of the image
image(matrix(testcov,10,10),col=gray(seq(0,1,length=255)))
##Transform the signals into pvalue form and begin identification
pvalue=pnorm(-testcov)
total=Networks.STD(pvalue,net,iter=5,nburns=1,
piall=c(0.8, 0.85, 0.9, 0.95),rhoall=c(0.5,1,5,10,15),
trace=FALSE)
}
\references{
Zhao, Y., Kang, J., Yu, T. A Bayesian nonparametric mixture model for selecting gene and gene-sub network, Annals of Applied Statistics, In press: 2014.

Zhou Lan, Jian Kang, Tianwei Yu, Yize Zhao, BayesNetDiscovery: an R package for network identifications via Bayesian nonparametric mixture models, working paper.

}

\author{
Zhou Lan, Jian Kang, Tianwei Yu and Yize Zhao
}


