% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmc.R
\name{rjmcmc_func}
\alias{rjmcmc_func}
\title{Perform reversible-jump MCMC post-process to select appropriate model between
proportional odds (PO) model and non-proportional odds (NPO) model}
\usage{
rjmcmc_func(g1, ginv1, g2, ginv2, or_alt, sd, pro_ctr, n, U)
}
\arguments{
\item{g1}{specify the bi-jections from the universal parameter psi to PO model parameter set}

\item{ginv1}{specify the bi-jections from the PO model parameter set to psi. It is the inverse transformation of g1.}

\item{g2}{specify the bi-jections from the universal parameter psi to NPO model parameter set}

\item{ginv2}{specify the bi-jections from the NPO model parameter set to psi. It is the inverse transformation of g2.}

\item{or_alt}{effect size to be detected (under H_1)
in terms of odds ratio}

\item{sd}{the standard error}

\item{pro_ctr}{distribution of clinical categories for the
control group}

\item{n}{sample size for each group and each interim look}

\item{U}{the desirability of each outcome level}
}
\value{
rjmcmc_func() returns the selection probabilities for PO and NPO model
}
\description{
Performs Bayesian multi-model inference, estimating posterior
model probabilities for 2 candidate models.
}
\examples{
\donttest{

g1 = function(psi){
  w = sum(psi[6:10])/5
  theta = c(psi[1], psi[2], psi[3], psi[4], psi[5],
            w, w-psi[7], w-psi[8], w-psi[9], w-psi[10])
  return(theta)
}

ginv1 = function(theta){

  w = sum(theta[6:10])
  psi = c(theta[1], theta[2], theta[3], theta[4], theta[5],
          w, theta[6]-theta[7], theta[6]-theta[8],
          theta[6]-theta[9], theta[6]-theta[10])
  return(psi)
}


g2 = function(psi){
  theta = psi
  return(theta)
}
ginv2 = function(theta){
  psi = theta
  return(psi)
}

out = rjmcmc_func(g1, ginv1, g2, ginv2, or_alt = c(1.4,1.4,1.4,1.4,1.4), sd = 0.2,
                  pro_ctr = c(0.58,0.05,0.17,0.03,0.04,0.13),
                  n = 100, U = c(100,80,65,25,10,0))
                  }
}
