% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_func.R
\name{power.two.grp.fixed.a0}
\alias{power.two.grp.fixed.a0}
\title{Power/type I error calculation for data with two groups (treatment and control group, no covariates) with fixed a0}
\usage{
power.two.grp.fixed.a0(
  data.type,
  n.t,
  n.c,
  historical = matrix(0, 1, 4),
  nullspace.ineq = ">",
  samp.prior.mu.t,
  samp.prior.mu.c,
  samp.prior.var.t,
  samp.prior.var.c,
  prior.mu.t.shape1 = 1,
  prior.mu.t.shape2 = 1,
  prior.mu.c.shape1 = 1,
  prior.mu.c.shape2 = 1,
  delta = 0,
  gamma = 0.95,
  nMC = 10000,
  nBI = 250,
  N = 10000
)
}
\arguments{
\item{data.type}{Character string specifying the type of response. The options are "Normal", "Bernoulli", "Poisson" and "Exponential".}

\item{n.t}{Sample size of the treatment group for the simulated datasets.}

\item{n.c}{Sample size of the control group for the simulated datasets.}

\item{historical}{(Optional) matrix of historical dataset(s). If \code{data.type} is "Normal", \code{historical} is a matrix with four columns:
\itemize{
\item The first column contains the sum of responses for the control group.
\item The second column contains the sample size of the control group.
\item The third column contains the sample variance of responses for the control group.
\item The fourth column contains the discounting parameter value \eqn{a_0} (between 0 and 1).
}
For all other data types, \code{historical} is a matrix with three columns:
\itemize{
\item The first column contains the sum of responses for the control group.
\item The second column contains the sample size of the control group.
\item The third column contains the discounting parameter value \eqn{a_0} (between 0 and 1).
}
Each row represents a historical dataset.}

\item{nullspace.ineq}{Character string specifying the inequality of the null hypothesis. The options are ">" and "<". If ">" is specified, the null hypothesis (for non-exponential data) is \eqn{H_0}: \eqn{\mu_t} - \eqn{\mu_c} \eqn{\ge} \eqn{\delta}. If "<" is specified, the null hypothesis is \eqn{H_0}: \eqn{\mu_t} - \eqn{\mu_c} \eqn{\le} \eqn{\delta}. The default choice is ">".}

\item{samp.prior.mu.t}{Vector of possible values of \eqn{\mu_t} to sample (with replacement) from. The vector contains realizations from the sampling prior (e.g. normal distribution) for \eqn{\mu_t}.}

\item{samp.prior.mu.c}{Vector of possible values of \eqn{\mu_c} to sample (with replacement) from. The vector contains realizations from the sampling prior (e.g. normal distribution) for \eqn{\mu_c}.}

\item{samp.prior.var.t}{Vector of possible values of \eqn{\sigma^2_t} to sample (with replacement) from. Only applies if \code{data.type} is "Normal". The vector contains realizations from the sampling prior (e.g. inverse-gamma distribution) for \eqn{\sigma^2_t}.}

\item{samp.prior.var.c}{Vector of possible values of \eqn{\sigma^2_c} to sample (with replacement) from. Only applies if \code{data.type} is "Normal". The vector contains realizations from the sampling prior (e.g. inverse-gamma distribution) for \eqn{\sigma^2_c}}

\item{prior.mu.t.shape1}{First hyperparameter of the initial prior for \eqn{\mu_t}. The default is 1. Does not apply if \code{data.type} is "Normal".}

\item{prior.mu.t.shape2}{Second hyperparameter of the initial prior for \eqn{\mu_t}. The default is 1. Does not apply if \code{data.type} is "Normal".}

\item{prior.mu.c.shape1}{First hyperparameter of the initial prior for \eqn{\mu_c}. The default is 1. Does not apply if \code{data.type} is "Normal".}

\item{prior.mu.c.shape2}{Second hyperparameter of the initial prior for \eqn{\mu_c}. The default is 1. Does not apply if \code{data.type} is "Normal".}

\item{delta}{Prespecified constant that defines the boundary of the null hypothesis. The default is zero.}

\item{gamma}{Posterior probability threshold for rejecting the null. The null hypothesis is rejected if posterior probability is greater \code{gamma}. The default is 0.95.}

\item{nMC}{Number of iterations (excluding burn-in samples) for the slice sampler or Gibbs sampler. The default is 10,000.}

\item{nBI}{Number of burn-in samples for the slice sampler or Gibbs sampler. The default is 250.}

\item{N}{Number of simulated datasets to generate. The default is 10,000.}
}
\value{
Power or type I error is returned, depending on the sampling prior used. If \code{data.type} is "Normal", average posterior means of \eqn{\mu_c}, \eqn{\tau} and \eqn{\tau_k}'s (if historical data is given) are also returned.
}
\description{
Power/type I error calculation for data with two groups (treatment and control group, no covariates) with fixed \eqn{a_0} using power priors
}
\details{
If \code{data.type} is "Bernoulli", "Poisson" or "Exponential", a single response from the treatment group is assumed to follow Bern(\eqn{\mu_t}), Pois(\eqn{\mu_t}) or Exp(rate=\eqn{\mu_t}), respectively,
where \eqn{\mu_t} is the mean of responses for the treatment group. If \code{data.type} is "Normal", a single response from the treatment group is assumed to follow \eqn{N(\mu_t, \tau^{-1})}
where \eqn{\tau} is the precision parameter.
The distributional assumptions for the control group data are analogous.

\code{samp.prior.mu.t} and \code{samp.prior.mu.c} can be generated using the sampling priors (see example).

If \code{data.type} is "Bernoulli", the initial prior for \eqn{\mu_t} is
beta(\code{prior.mu.t.shape1}, \code{prior.mu.t.shape2}).
If \code{data.type} is "Poisson", the initial prior for \eqn{\mu_t} is
Gamma(\code{prior.mu.t.shape1}, rate=\code{prior.mu.t.shape2}).
If \code{data.type} is "Exponential", the initial prior for \eqn{\mu_t} is
Gamma(\code{prior.mu.t.shape1}, rate=\code{prior.mu.t.shape2}).
The initial priors used for the control group data are analogous.

If \code{data.type} is "Normal", each historical dataset \eqn{D_{0k}} is assumed to have a different precision parameter \eqn{\tau_k}.
The initial prior for \eqn{\tau} is the Jeffery's prior, \eqn{\tau^{-1}}, and the initial prior for \eqn{\tau_k} is \eqn{\tau_k^{-1}}.
The initial prior for the \eqn{\mu_c} is the uniform improper prior.

If a sampling prior with support in the null space is used, the value returned is a Bayesian type I error rate.
If a sampling prior with support in the alternative space is used, the value returned is a Bayesian power.

If \code{data.type} is "Normal", Gibbs sampling is used for model fitting. For all other data types,
numerical integration is used for modeling fitting.
}
\examples{
data.type <- "Bernoulli"
n.t <- 100
n.c <- 100

# Simulate three historical datasets
historical <- matrix(0, ncol=3, nrow=3)
historical[1,] <- c(70, 100, 0.3)
historical[2,] <- c(60, 100, 0.5)
historical[3,] <- c(50, 100, 0.7)

# Generate sampling priors
set.seed(1)
b_st1 <- b_st2 <- 1
b_sc1 <- b_sc2 <- 1
samp.prior.mu.t <- rbeta(50000, b_st1, b_st2)
samp.prior.mu.c <- rbeta(50000, b_st1, b_st2)
# The null hypothesis here is H0: mu_t - mu_c >= 0. To calculate power,
# we can provide samples of mu.t and mu.c such that the mass of mu_t - mu_c < 0.
# To calculate type I error, we can provide samples of mu.t and mu.c such that
# the mass of mu_t - mu_c >= 0.
sub_ind <- which(samp.prior.mu.t < samp.prior.mu.c)
# Here, mass is put on the alternative region, so power is calculated.
samp.prior.mu.t <- samp.prior.mu.t[sub_ind]
samp.prior.mu.c <- samp.prior.mu.c[sub_ind]

N <- 1000 # N should be larger in practice
result <- power.two.grp.fixed.a0(data.type=data.type, n.t=n.t, n.c=n.t, historical=historical,
                                 samp.prior.mu.t=samp.prior.mu.t, samp.prior.mu.c=samp.prior.mu.c,
                                 delta=0, N=N)

}
\references{
Yixuan Qiu, Sreekumar Balan, Matt Beall, Mark Sauder, Naoaki Okazaki and Thomas Hahn (2019). RcppNumerical: 'Rcpp' Integration for Numerical Computing Libraries. R package version 0.4-0. https://CRAN.R-project.org/package=RcppNumerical

Chen, Ming-Hui, et al. "Bayesian design of noninferiority trials for medical devices using historical data." Biometrics 67.3 (2011): 1163-1170.
}
\seealso{
\code{\link{two.grp.fixed.a0}}
}
