% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Walter_2015_JCR.R
\docType{data}
\name{Walter_2015_JCR}
\alias{Walter_2015_JCR}
\title{Walter_2015_JCR}
\format{
A data frame with 1237 rows and 13 variables
}
\source{
Walter, Barbara F. (2015), Why Bad Governance Leads to Repeat Civil War,  Journal of Conflict Resolution 59(7), 1242 - 1272.
}
\usage{
data(Walter_2015_JCR)
}
\description{
Subsetted version of a time-series-cross-sectional (TSCS) dataset  used in \href{https://journals.sagepub.com/doi/abs/10.1177/0022002714528006}{Walter (2015)}.
It has data on duration of post-war peace as well as information on other relevant economic and political data.
}
\details{
\describe{
   \item{year}{year.}
   \item{lastyear}{last observation year.}
   \item{renewed_war}{binary variable coded as 1 if the war was fought.}
   \item{fhcompor1}{Freedom House civil liberties index.}
   \item{lgdpl}{log of per capita GDP in 2005 dollars.}
   \item{comprehensive}{combatants signed comprehensive peace agreement.}
   \item{victory}{end of previous war with outright victory.}
   \item{instabl}{dummy that indicates whether there was a positive or negative change in the Polity 2 score in the previous country-year.}
   \item{intensityln}{deaths per year -- logged.}
   \item{ethfrac}{index of ethnic fractionalization.}
   \item{unpko}{number of UN peacekeepers on the ground.}
   \item{ccode}{country code.}
   \item{id}{unique conflict identifier.}
}
}
\keyword{datasets}
