% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_EAP_CI_srsc.R
\name{summary_EAP_CI_srsc}
\alias{summary_EAP_CI_srsc}
\title{Summary}
\usage{
summary_EAP_CI_srsc(StanS4class, dig = 5, summary = TRUE)
}
\arguments{
\item{StanS4class}{This is an output of \code{rstan::stan} for a single reader and a single modality. More precisely, this is an object of some inherited class from the S4 class called stanfit in the rstan package.}

\item{dig}{digits of estimates.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; whether to list verbose data of estimates when printing. If TRUE then verbose summary and additional estimates are printed in the R console. If FALSE, the output is minimal. I regret, this variable name should be verbose.}
}
\value{
The estimates
}
\description{
EAP and CI
}
\examples{
\donttest{
#================The first example======================================


#1) Build the data for singler reader and single modality  case.

dat <- list(c=c(3,2,1),    #Confidence level
            h=c(97,32,31), #Number of hits for each confidence level
            f=c(1,14,74),  #Number of false alarms for each confidence level

            NL=259,       #Number of lesions
            NI=57,        #Number of images
            C=3)          #Number of confidence level

# where, c denotes Confidence level,
#        h denotes number of Hits for each confidence level,
#        f denotes number of False alarms for each confidence level,
#        NL denotes Number of Lesions,
#        NI denotes Number of Images,


#2) Fit the FROC model.
  #Since dataset named dat are single reader and single modality,
  #the function build the such model by running the following code.

          fit <-   BayesianFROC::fit_Bayesian_FROC(dat)

 #3) Extract estimates, that is posterior means and 95\% credible intervals


        estimates <- summary_EAP_CI_srsc(  fit )


}# dottest
}
