% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicate_MRMC_data.R
\name{from_array_to_vector}
\alias{from_array_to_vector}
\title{Transform from an array to a vector}
\usage{
from_array_to_vector(Three.dim.array)
}
\arguments{
\item{Three.dim.array}{Three dimensional array, such as the number of hits for each confidence level, modality and reader. Or false alarms. Since the author construct the substituting data list as one dimensional (one index) array, it needs to reconstruct to the three indexed array  from one dimensional array whose subscript is [confidence level, modality, reader ] or vice versa.}
}
\value{
One dimensional array transformed from user input three dimensional array.
}
\description{
In the stan files, the number of hits, false alarms and hit rates in binomial assumption for MRMC case are written in the three indexed array format. Three index are constituted from confidence levels, modality ID, reader ID.
However the data substituting the function BayesianFROC::fit_Bayesian_FROC() are written in the vector.
So, to connect these different format, the author make this function.
}
\examples{
\donttest{
  h.array.etc <- hits_from_thresholds()

  h.vector     <- from_array_to_vector(h.array.etc$h)



  }
}
