% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argMax.R
\name{names_argMax}
\alias{names_argMax}
\title{Extract name from a real vector whose component is the maximal one}
\usage{
names_argMax(numeric_vector)
}
\arguments{
\item{numeric_vector}{A vector, each component is a real number (an object of class numeric).}
}
\value{
A character, indicating a name of some component of vector.
 The corresponding component is the minimal component.
}
\description{
Extracts an object of class character from a named vector.
The component whose name is the extracted one is the maximal component of vector.
}
\examples{




v<-c(11,22,33,22)
names(v)<-c("1-st","2-nd","3-rd","4-th")
names_argMax(v)





v<-c(11,NaN,33,22)
names(v)<-c("1-st","2-nd","3-rd","4-th")
names_argMax(v)






\dontrun{


 f <- fit_Bayesian_FROC(
                         ite  = 111,
                          cha = 1,
                     dataList = d)


 a <- summary(f)$summary[,"Rhat"]

 names_argMax(a)




}

}
