% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_Bayesian_FROC.R
\name{fit_MRMC}
\alias{fit_MRMC}
\title{Fit and Draw the FROC models (curves)}
\usage{
fit_MRMC(
  dataList,
  DrawCurve = FALSE,
  type_to_be_passed_into_plot = "p",
  verbose = TRUE,
  print_CI_of_AUC = TRUE,
  PreciseLogLikelihood = FALSE,
  summary = TRUE,
  dataList.Name = "",
  prior = 1,
  ModifiedPoisson = TRUE,
  mesh.for.drawing.curve = 10000,
  significantLevel = 0.7,
  cha = 1,
  war = floor(ite/5),
  ite = 10000,
  dig = 3,
  see = 1234569,
  Null.Hypothesis = FALSE,
  prototype = FALSE,
  model_reparametrized = FALSE,
  Model_MRMC_non_hierarchical = TRUE,
  ww = -0.81,
  www = 0.001,
  mm = 0.65,
  mmm = 0.001,
  vv = 5.31,
  vvv = 0.001,
  zz = 1.55,
  zzz = 0.001,
  ...
)
}
\arguments{
\item{dataList}{A list, specifying an FROC data to be fitted a model.
It consists of data of numbers
of TPs, FPs, lesions, images.
.In addition, if in case of  mutiple readers or mutiple modalities,
then modaity ID and reader ID are included also.

 The \code{dataList} will be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}. This is a variable in the function \code{rstan::sampling()} in which it is named \code{data}.



 For the single reader and a single modality data, the \code{dataList} is made by the following manner:

\code{ dataList.Example <- list(       }

\code{            h = c(41,22,14,8,1),  # number of hits for each confidence level }

\code{            f = c(1,2,5,11,13),  # number of false alarms for each confidence level   }

\code{            NL = 124,  # number of lesions (signals)   }

\code{            NI = 63,  # number of images (trials)  }

\code{            C = 5)   # number of confidence, .. the author thinks it can be calculated as the length of h or f ...? ha, why I included this. ha .. should be omitted.      }

Using this object \code{dataList.Example}, we can apply \code{fit_Bayesian_FROC()} such as \code{fit_Bayesian_FROC(dataList.Example)}.






To make this \R object \code{dataList} representing FROC data, this package provides three functions:
\describe{
\item{  \code{ \link{convertFromJafroc}()}           }{ If  data is a           \emph{\strong{JAFROC xlsx}} formulation.}
\item{  \code{ \link{dataset_creator_new_version}()} }{ Enter TP and FP data    \emph{\strong{by table   }}.            }
\item{  \code{ \link{create_dataset}()}              }{ Enter TP and FP data by \emph{\strong{interactive}} manner.     }
}

Before fitting a model,
 we can confirm our dataset is correctly formulated
 by using the function \strong{\code{ \link{viewdata}()}}.


----------------------------------------------------------------------------------------


  \strong{A Single reader and a single modality (SRSC) case.}


----------------------------------------------------------------------------------------

In a single reader and a single modality case (srsc),
\code{dataList} is a list consisting of  \code{f, h, NL, NI, C} where
 \code{f, h} are numeric vectors
 and  \code{NL, NI, C} are positive integers.

\describe{
\item{ \code{f}  }{Non-negative integer vector  specifying  number of false alarms    associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{h}  }{Non-negative integer vector  specifying  number  of Hits  associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{NL} }{A positive integer, representing  Number of Lesions.}
\item{ \code{NI} }{A positive integer, representing  Number of Images. }
\item{ \code{C}  }{A positive integer, representing  Number of Confidence level. }
}




The detail of these dataset, see the datasets  endowed with this package.
'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
Note that confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} in the inner program and do not refer from user input data, where \code{C} is the highest number of confidence levels.
So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.


\strong{\emph{ data Format:}}

 \emph{            A single reader and a single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
definitely present  \tab  \code{c[1] = }5 \tab \code{f[1] = }\eqn{F_5} = 1 \tab  \code{h[1] = }\eqn{H_5} = 41 \cr
 probably present   \tab  \code{c[2] = }4 \tab \code{f[2] = }\eqn{F_4} = 2 \tab  \code{h[2] = }\eqn{H_4} = 22 \cr
 equivocal                 \tab  \code{c[3] = }3 \tab \code{f[3] = }\eqn{F_3} = 5 \tab  \code{h[3] = }\eqn{H_3} = 14  \cr
 subtle                    \tab  \code{c[4] = }2 \tab \code{f[4] = }\eqn{F_2} = 11 \tab \code{h[4] = }\eqn{H_2} = 8  \cr
 very subtle        \tab  \code{c[5] = }1 \tab \code{f[5] = }\eqn{F_1} = 13 \tab \code{h[5] = }\eqn{H_1} = 1  \cr
 }

---------------------------------------------------------------------------------------------------



*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP

Note that  in FROC data, all confidence level means \emph{present} (\emph{diseased, lesion}) case only, no confidence level indicating absent. Since each reader marks his suspicious location only if he thinks  lesions are \emph{present}, and marked positions generates the hits or false alarms, \emph{thus} each confidence level represents that lesion is \emph{present}.
In the absent case, reader does not mark any locations and hence, the absent confidence level does not relate this dataset. So, if reader think it is no lesion, then in such case confidence level is not needed.


Note that the first column of confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} automatically in the inner program and do not refer from user input data even if it is specified explicitly, where \code{C} is the highest number of confidence levels.
So you should check the compatibility of your
data and the confidence  level vector  \code{  c <-c(rep(C:1))}
via a table which can be displayed by the function \code{\link{viewdata}()}.









---------------------------------------------------------------------------------------

  \strong{Multiple readers and multiple modalities case, i.e., MRMC case}


---------------------------------------------------------------------------------------


In case of  multiple readers and multiple modalities, i.e., MRMC case,
in order to apply the function \code{fit_Bayesian_FROC()},
dataset represented by an \R list object representing FROC data
must contain components \code{m,q,c,h,f,NL,C,M,Q}.

\describe{
\item{ \code{C }  }{A positive integer, representing  the \emph{\strong{highest}} number of confidence level, this is a scalar.}
\item{ \code{M }  }{A positive integer vector, representing  the number of \emph{\strong{modalities}}.  }
\item{ \code{Q }  }{A positive integer, representing  the number of \emph{\strong{readers}}. }
\item{ \code{m }  }{A vector of positive integers,  representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A vector of positive integers,  representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{c }  }{A vector of positive integers,  representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{h }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{hits}}.   }
\item{ \code{f }  }{A vector of non-negative integers,  representing  the number of \emph{\strong{false alarms}}.  }
\item{ \code{NL}  }{A positive integer, representing  the Total number of \emph{\strong{lesions}} for all images, this is a scalar.}
}



Note that the maximal number of confidence level (denoted by  \code{C}) are included in
the above \R object.
However,
each confidence level vector is not included in the data,
 because it is created automatically from \code{C}.
  To confirm  false positives and hits
are correctly ordered with respect to
 the automatically generated confidence vector,

the function \code{\link{viewdata}()} shows the table.
Revised 2019 Nov 27
Revised 2019 Dec 5



\strong{\emph{ Example data. }}



 \emph{ Multiple readers and multiple modalities ( i.e., MRMC) }




---------------------------------------------------------------------------------------------------

\tabular{ccccc}{
 \strong{Modality ID } \tab   \strong{Reader ID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{m} \tab  \code{ q}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
   -------------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
  1 \tab 1 \tab 3 \tab 20 \tab 111\cr
  1 \tab 1 \tab 2 \tab 29 \tab  55\cr
  1 \tab 1 \tab 1 \tab 21 \tab  22\cr
  1 \tab 2 \tab 3 \tab  6 \tab 100\cr
  1 \tab 2 \tab 2 \tab 15 \tab  44\cr
  1 \tab 2 \tab 1 \tab 22 \tab  11\cr
  2 \tab 1 \tab 3 \tab  6 \tab  66\cr
  2 \tab 1 \tab 2 \tab 24 \tab  55\cr
  2 \tab 1 \tab 1 \tab 23 \tab   1\cr
  2 \tab 2 \tab 3 \tab  5 \tab  66\cr
  2 \tab 2 \tab 2 \tab 30 \tab  55\cr
  2 \tab 2 \tab 1 \tab 40 \tab  44\cr
}
---------------------------------------------------------------------------------------------------




*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP}

\item{DrawCurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the curve is to be drawn. TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}.
The reason why the author make this variable \code{DrawCurve} is that it takes long time in MRMC case to draw curves, and thus Default value is \code{FALSE} in the case of MRMC data.}

\item{type_to_be_passed_into_plot}{"l" or "p".}

\item{verbose}{A logical, if \code{TRUE}, then the redundant summary is printed in \R console.
If \code{FALSE}, it suppresses output from this function.}

\item{print_CI_of_AUC}{Logical, if \code{TRUE} then Credible intervals of AUCs for each modality are plotted.}

\item{PreciseLogLikelihood}{Logical, that is \code{TRUE} or \code{FALSE}. If \code{PreciseLogLikelihood  = TRUE}(default), then Stan calculates the precise log likelihood with target formulation.
If \code{PreciseLogLikelihood  = FALSE}, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.
In past, I distinct the stan file, one is target formulation and the another is not. But non-target formulation cause some Jacobian warning,
thus I made all stanfile with target formulation when I uploaded to CRAN.
 Thus this variable is now meaningless.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{dataList.Name}{This is not for user, but the author for this package development.}

\item{prior}{positive integer, to select the prior}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



For more details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}

\item{mesh.for.drawing.curve}{A positive large integer, indicating number of dots drawing the curves, Default =10000.}

\item{significantLevel}{This is a number between 0 and 1. The results are shown if posterior probabilities are greater than this quantity.}

\item{cha}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{chains}.  A positive integer representing   the number of chains generated by Hamiltonian Monte Carlo method,
and, Default = 1.}

\item{war}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{warmup}.  A positive integer representing the Burn in period, which must be less than \code{ite}. Defaults to
war = floor(ite/5)=10000/5=2000,}

\item{ite}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{iter}. A positive integer representing  the  number of samples synthesized by Hamiltonian Monte Carlo method,
and, Default = 10000.}

\item{dig}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
Default = 5,}

\item{see}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{seed}.  A positive integer representing  seed used in stan,
Default = 1234567.}

\item{Null.Hypothesis}{Logical, that is \code{TRUE} or \code{FALSE}.
If \code{Null.or.Alternative.Hypothesis  = FALSE}(default),
 then fit the \emph{alternative model} to \code{dataList} (for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }).
If \code{Null.or.Alternative.Hypothesis  = TRUE},
 then fit the \emph{null model} to \code{dataList}.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }).
 Note that the null model is constructed under the null hypothesis that
 all modality are same observer performance ability.
 The alternative model is made under the assumption that all modality are not same.
The reason why author creates this parameter is to test the null hypothesis by the Bayes factor.
But the result of test is not desired one for me. Thus the test is under construction.}

\item{prototype}{A logical, if \code{TRUE} then the model is no longer
a generative model. Namely, in generally speaking,
 a dataset drawn from the model
 cannot satisfy the condition that
 the sum of the numbers of hits over all confidence levels
  is bounded from the above by the number of lesions, namely,

\deqn{ \Sigma_c H_c \le N_L }

However, this model (\code{TRUE} )
 is good in the sense that it admits various initial values of MCMC sampling.

 if \code{FALSE}, then the model is precisely
  statistical model in the sense that
   any dataset drawn from the model
   satisfies that the sum of the number of hits is
 not greater than the number of lesions, namely,

  \deqn{ \Sigma_c H_c \le N_L. }
  This model is theoretically perfect.
   However, in the practically,
    the calculation will generates
     some undesired results
      which caused by the so-called floo .... I forget English :'-D.
 The flood point??? I forgeeeeeeeeeeeeet!!
  Ha. So, prior synthesizes very small hit rates such as 0.0000000000000001234 and it cause the non accurate calculation such as 0.00000,,,00000123/0.000.....000012345= 0.0012 which becomes hit rate and thus OH No!.
 Then it synthesizes Bernoulli success rate which is not less than 1 !!
 To avoid this, the author should develop the theory of prior to avoid this very small numbers, however the author has idea but now it does not success.




If \code{prototype = TRUE},
then the model for hits is the following:

\deqn{H_5 \sim Binomial(p_5,N_L)}
\deqn{H_4 \sim Binomial(p_4,N_L)}
\deqn{H_3 \sim Binomial(p_3,N_L)}
\deqn{H_2 \sim Binomial(p_2,N_L)}
\deqn{H_1 \sim Binomial(p_1,N_L)}


On the other hand,
if \code{prototype = FALSE},
then the model for hits is the following:

\deqn{H_5 \sim Binomial(               p_5,N_L      )                        }
\deqn{H_4 \sim Binomial( \frac{p_4}{1-p_5},N_L - H_5)                        }
\deqn{H_3 \sim Binomial( \frac{p_3}{1-p_5-p_4},N_L - H_5-H_4)                }
\deqn{H_2 \sim Binomial( \frac{p_2}{1-p_5-p_4-p_3},N_L - H_5-H_4-H_3)        }
\deqn{H_1 \sim Binomial( \frac{p_1}{1-p_5-p_4-p_3-p_2},N_L - H_5-H_4-H_3-H_2)}


Each number of lesions is adjusted
so that the sum of hits \eqn{\Sigma_c H_c} is less than
the number of lesions (signals, targets) \eqn{N_L}.
And hence the model in case of \code{prototype = FALSE}
is a generative model in the sense that
it can replicate datasets of FROC  arises.
Note that the adjustment of the number of lesions
in the above manner leads us the adjustment of hit rates.
The reason why we use the hit rates such as
\eqn{\frac{p_2}{1-p_5-p_4-p_3}} instead of \eqn{p_c} is that
it ensures the equality \eqn{ E[H_c/N_L] = p_c}.
 This equality is very important.
To establish Bayesian FROC theory so that it is
 compatible to the classical FROC theory, we need the following two equations,

  \deqn{ E[H_c/N_L] = p_c,}
  \deqn{ E[F_c/N_X] = q_c,}

where  \eqn{E} denotes the expectation and \eqn{N_X} is the number of lesion or the number of images and
\eqn{q_c} is a false alarm rate, namely, \eqn{ F_c \sim Poisson( q_c N_X)}.

Using the above two equations, we can establish the alternative Bayesian FROC theory preserving classical notions and
formulas. For the details, please see the author's pre print:

Bayesian Models for ,,, for?? I forget my paper title .... :'-D.
What the hell!? I forget,... My health is so bad to forget , .... I forget.




The author did not notice that the prototype is not a generative model. And hence
the author revised the model so that the model is exactly generative model.

But the reason why the author remains the prototype model(\code{prototype = TRUE})
is that the convergence of MCMC sampling in case of MRMC is not good in the current model (\code{prototype = FALSE}) .
Because it uses fractions \eqn{\frac{p_1}{1-p_5-p_4-p_3-p_2}} and which is very dangerous to numerical perspective.
For example, if \eqn{p_1} is very small, then the numerator and denominator of \eqn{\frac{p_1}{1-p_5-p_4-p_3-p_2}}  is very small.
Both of them is like 0.000000000000000123.... and such small number causes the non accurate results.
So, sometimes, it occurs that \eqn{\frac{p_1}{1-p_5-p_4-p_3-p_2} >1} which never occur in the theoretical perspective but
unfortunately, in numerically occurs.

SO, now, the author try to avoid such phenomenon by using priors but it now does not success.



Here of course we interpret the terms
such as \eqn{N_L - H_5-H_4-H_3} as
the remained targets after
reader get hits. The author thinks it is another manner to do so like \eqn{N_L -H_1-H2-H_3}, but it does not be employed.
Since the author thinks that the reader will assign his suspicious lesion location from high confidence level and in this view point
the author thinks it should be considered that targets are found from the highest confidence suspicious location.}

\item{model_reparametrized}{A logical, if TRUE, then a model under construction is used.}

\item{Model_MRMC_non_hierarchical}{A logical.
If \code{TRUE}, then the model of multiple readers and multiple modalities consits of
no hyper parameters.
The reason why the author made this parameter is that the hyper parameter make the MCMC posterior samples be unstable.
And also, my hierarachical model is not so good in theoretical perspective.
Thus, I made this. The Default is \code{TRUE}.}

\item{ww}{Each of which is a real number  specifying one of the parameter of prior}

\item{www}{Each of which is a real number  specifying one of the parameter of prior}

\item{mm}{Each of which is a real number  specifying one of the parameter of prior}

\item{mmm}{Each of which is a real number  specifying one of the parameter of prior}

\item{vv}{Each of which is a real number  specifying one of the parameter of prior}

\item{vvv}{Each of which is a real number  specifying one of the parameter of prior}

\item{zz}{Each of which is a real number  specifying one of the parameter of prior}

\item{zzz}{Each of which is a real number  specifying one of the parameter of prior}

\item{...}{Additional arguments}
}
\description{
Fit and Draw the FROC models (curves).
}
