% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square_goodness_of_fit.R
\name{Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean}
\alias{Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean}
\title{Chi square statistic (goodness of fit) in the case
 of MRMC at the pair of given data
  and each MCMC sample}
\usage{
Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean(
  StanS4class,
  summary = TRUE,
  dl_is_an_array_of_C_only_and_not_C_M_Q = TRUE
)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

To be passed to \code{\link{DrawCurves}()} ... etc}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{dl_is_an_array_of_C_only_and_not_C_M_Q}{A Boolean, if \code{TRUE},
then false rate \code{lambda} simply
denoted by \code{l} in \R script ( \eqn{\lambda} )
is an vector \code{l[C]}. If false, then the false
 alarm rate is an array \code{l[C,M,Q]}.}
}
\value{
A list, calculated by each modality reader and cofidence level, and MCMC samples.
 A one the component of list contains \{ \eqn{\chi^2(Data|\theta_i)} ; i= 1,2,3,...n\}, where \eqn{n} is the number of MCMC iterations.

Each component
of list isan array
 whose index indicats  \code{[MCMC, Confidence, Modality, Reader]  }.

Each component of list is
  \code{an array whose index indicats [MCMC, C, M, Q]}.

To be passed to the calculation of Posterior predictive p value,
I need the sum of return value,
that is, sum of C,M,Q and resulting quantities
construct a vetor whose length is a same as the number of MCMC iterations.
I love you. I need you. So, to calculate such quantites,
 the author .... will make a new function.


 Also, it retains the posterior mean of chi square statistic for
 an assumed occurrence of the data \eqn{D}:


   \deqn{\chi^2(Data)  = \int \chi^2(Data|\theta) \pi(\theta|D)d  \theta}
}
\description{
Revised 2019 Oct 16.
Revised 2019 Nov 1.
Revised 2019 Nov 27.
Revised 2019 Dec 1.

In the following, we explain what this function calculates.

Let \eqn{\chi^2(y|\theta)} be a
\emph{chi square goodness of fit} statistic which is defined by


 ( Observed data - Expectation \eqn{)^2}/Exectation.






 In MRMC cases, it is defined as follows.

\deqn{\chi^2(D|\theta) := \sum_{r=1}^R \sum_{m=1}^M \sum_{c=1}^C \biggr( \frac{[ H_{c,m,r}-N_L\times p_{c,m,r}(\theta)]^2}{N_L\times p_{c,m,r}(\theta)}+\frac{[F_{c,m,r}-(\lambda _{c} -\lambda _{c+1} )\times N_{L}]^2}{(\lambda_{c}(\theta) -\lambda_{c+1}(\theta) )\times N_{L} }\biggr).}

where  a dataset \eqn{D} consists of the
pairs of the number of False Positives and the number of True
Positives  \eqn{ (F_{c,m,r}, H_{c,m,r}) }
together with the number of lesions \eqn{N_L}
and the number of images \eqn{N_I} and
 \eqn{\theta} denotes the model parameter.









 Note that we can rewrite the chi square as follows.

  \deqn{\chi^2(D|\theta) := \sum_{r=1}^R \sum_{m=1}^M \sum_{c=1}^C \biggr( \frac{[ H_{c,m,r}-  E_{\theta}[H_{c,m,r}] ]^2}{E_{\theta}[H_{c,m,r}]}+\frac{[F_{c,m,r}- E_{\theta}[F_{c,m,r}]   ]^2}{    E_{\theta}[F_{c,m,r}]   }\biggr).}

So, the chi square has two terms.

1) The first term is the difference of hit
and its expectation.

2) The second term   is the differences of observed false alarms and its expectatioins.

  In this function, we calculate each terms, separately.
   So, return values retain these two terms, separately.



In this function, we calculate the following (I) and (II):



\strong{ (I) A vector -------------------}


Let us denote a collection of
posterior MCMC samples for a given dataset \eqn{D} by

\deqn{   \theta_1 ,   \theta_2 ,    \cdots , \theta_i,    \cdots ,    \theta_N,}
namely, each \eqn{\theta_i} is
synthesized from posterior
\eqn{\pi(\theta|D)}, \eqn{\theta_i \sim \pi(\theta|D).}


Substituing these MCMC samples into the above definition of the chi square,
 we obtain the following vector as a return value of this function.

     \deqn{ \chi^2(D|\theta_1),}
     \deqn{ \chi^2(D|\theta_2),}
     \deqn{ \chi^2(D|\theta_3),}
     \deqn{          :         }
     \deqn{          :         }
     \deqn{ \chi^2(D|\theta_N).}



 \strong{ (II) A mean of the above vector, namely, the posterior mean of the chi square over all MCMC samples -------------}


Using the set of chi squares  \eqn{(\chi^2(D|\theta_i);i=1,...,N)}
calculated for each posterior MCMC samples \eqn{\theta_i \sim \pi(\theta|D).}
,
the function also calculates the posterior mean of the chi square statistic, namely,


      \deqn{\int   \chi^2(D|\theta)\pi(\theta|D) d\theta,}


by approximating it as

      \deqn{\frac{1}{N} \sum _{i=1} ^N \chi^2(D|\theta_i),}

where \eqn{\pi(\theta|D)} denotes the posterior probability density under the given data \eqn{D}.

Do not confuse it with the following

      \deqn{   \chi^2(D|\theta^*).}

where \eqn{\theta^*} denotes the posterior estimates, i.e.,  \eqn{ \theta^* := \int \theta \pi(\theta|D) d\theta}.
}
\details{
This function is implemented by
vectorizations and further techinics.
When the author review this, I
 find my past work is great,...
 I forget that I made this.
But this function is great.

Revised 2019 Nov 1
}
\examples{


\dontrun{

#========================================================================================
#            1) Create a fitted model object for data named  dd
#========================================================================================




     fit <- fit_Bayesian_FROC(    ite = 1111, # Number of MCMC iterations
                                  cha = 1,
                             dataList = BayesianFROC::dd # This is a MRMC dataset.
                              )


#========================================================================================
#            2) Calculate a chi square and meta data
#========================================================================================



            a <- Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean(fit)



#========================================================================================
#            3) Extract a chi square
#========================================================================================






                              chi.square  <- a$chi.square




#========================================================================================
#     A case of single reader is special in the programming perspective
#                                                                         2020 Feb 24
#========================================================================================


f <- fit_Bayesian_FROC( ite  = 1111,
                         cha = 1,
                     summary = TRUE,
                    dataList = dddd,
                         see = 123)

Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean(f)



# Revised 2019 August 19
#         2019 Nov 1

}# dontrun



}
