% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawCurves.R
\name{DrawCurves_srsc}
\alias{DrawCurves_srsc}
\title{Draw the FROC  curves}
\usage{
DrawCurves_srsc(
  StanS4class,
  type = 4,
  type_to_be_passed_into_plot = "p",
  title = TRUE,
  indexCFPCTP = FALSE,
  upper_x,
  upper_y,
  lower_X = 0,
  lower_y = 0,
  new.imaging.device = TRUE,
  Drawcol = TRUE,
  DrawFROCcurve = TRUE,
  DrawAFROCcurve = FALSE,
  DrawCFPCTP = TRUE,
  Draw.inner.circle.for.CFPCTPs = TRUE,
  DrawAUC = TRUE
)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

To be passed to \code{\link{DrawCurves}()} ... etc}

\item{type}{An integer, for the color of background and etc.}

\item{type_to_be_passed_into_plot}{"l" or "p".}

\item{title}{Logical: \code{TRUE} of \code{FALSE}.  If \code{TRUE}  (default), then title of curves are drawn.}

\item{indexCFPCTP}{TRUE of FALSE. If TRUE, then the cumulative false and hits are specified with its confidence level.}

\item{upper_x}{A non-negative real number. This is a upper bound for the axis of the horisontal coordinate of FROC curve.}

\item{upper_y}{A non-negative real number. This is a upper bound for the axis of the vertical coordinate of FROC curve.}

\item{lower_X}{A non-negative real number. This is a lower bound for the axis of the horisontal coordinate of FROC curve.}

\item{lower_y}{A non-negative real number. This is a lower bound for the axis of the vertical coordinate of FROC curve.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{Drawcol}{Logical: \code{TRUE} of \code{FALSE}. Whether the (A)FROC curve is to be drawn  by using color of dark theme. The Default value is a \code{TRUE}.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not FROC curves are shown.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not AFROC curves are shown.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}.  Whether or not the pairs of \emph{FPF} and \emph{TPF} are shown.}

\item{Draw.inner.circle.for.CFPCTPs}{TRUE or FALSE. If true, then to plot the cumulative false positives and true positives the plot points is depicted by two way, one is a large circle and one is a small circle. By see the small circle, user can see the more precise position of these points.}

\item{DrawAUC}{TRUE of FALSE. If TRUE then area under the  AFROC curves are painted.}
}
\description{
Draw an FROC  curves and an AFROC curves.
}
