% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcMetropolis.R
\name{Metropolis}
\alias{Metropolis}
\title{Creates a Metropolis-type MCMC with options for covariance adaptatin, delayed rejection, Metropolis-within-Gibbs, and tempering}
\usage{
Metropolis(bayesianSetup, settings = list(startValue = NULL, optimize = T,
  proposalGenerator = NULL, consoleUpdates = 100, burnin = 0, thin = 1, parallel
  = NULL, adapt = T, adaptationInterval = 500, adaptationNotBefore = 3000,
  DRlevels = 1, proposalScaling = NULL, adaptationDepth = NULL,
  temperingFunction = NULL, gibbsProbabilities = NULL, message = TRUE))
}
\arguments{
\item{bayesianSetup}{either an object of class bayesianSetup created by \code{\link{createBayesianSetup}} (recommended), or a log target function}

\item{settings}{a list of settings - possible options follow below}

\item{startValue}{startValue for the MCMC and optimization (if optimize = T). If not provided, the sampler will attempt to obtain the startValue from the bayesianSetup}

\item{optimize}{logical, determines whether an optimization for start values and proposal function should be run before starting the sampling}

\item{proposalGenerator}{option proposalgenerator object (see \code{\link{createProposalGenerator}})}

\item{proposalScaling}{additional scaling parameter for the proposals, needs to be as long as DRlevels. Defaults to 0.5^(- 0:(mcmcSampler$settings$DRlevels -1)}

\item{burnin}{number of iterations treated as burn-in. These iterations are not recorded in the chain.}

\item{thin}{thinning parameter. Determines the interval in which values are recorded.}

\item{consoleUpdates}{integer, determines the frequency with which sampler progress is printed to the console}

\item{adapt}{logical, determines wheter an adaptive algorithm should be implemented. Default is TRUE.}

\item{adaptationInterval}{integer, determines the interval  of the adaption if adapt = TRUE.}

\item{adaptationNotBefore}{integer, determines the start value for the adaption if adapt = TRUE.}

\item{DRlevels}{integer, determines the number of levels for a delayed rejection sampler. Default is 1, which means no delayed rejection is used.}

\item{temperingFunction}{function to implement simulated tempering in the algorithm. The function describes how the acceptance rate will be influenced in the course of the iterations.}

\item{gibbsProbabilities}{vector that defines the relative probabilities of the number of parameters to be changes simultaniously.}

\item{message}{logical determines whether the sampler's progress should be printed}
}
\description{
Creates a Metropolis-type MCMC with options for covariance adaptatin, delayed rejection, Metropolis-within-Gibbs, and tempering
}
\details{
The 'Metropolis' function is the main function for all Metropolis based samplers in this package. To call the derivatives from the basic Metropolis-Hastings MCMC, you can either use the corresponding function (e.g. \code{\link{AM}} for an adaptive Metropolis sampler) or use the parameters to adapt the basic Metropolis-Hastings. The advantage of the latter case is that you can easily combine different properties (e.g. adapive sampling and delayed rejection sampling) without changing the function.
}
\examples{

# Running the metropolis via the runMCMC with a proposal covariance generated from the prior 
# (can be useful for complicated priors)

ll = function(x) sum(dnorm(x, log = TRUE))
setup = createBayesianSetup(ll, lower = c(-10,-10), upper = c(10,10))

samples = setup$prior$sampler(1000)

generator = createProposalGenerator(diag(1, setup$numPars))
generator = updateProposalGenerator(generator, samples, manualScaleAdjustment = 1, message = TRUE)

settings =  list(proposalGenerator = generator, optimize = FALSE, iterations = 500)  

out = runMCMC(bayesianSetup = setup, sampler = "Metropolis", settings = settings)
}
\author{
Florian Hartig
}
