% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testFunctions.R
\name{generateTestDensityMultiNormal}
\alias{generateTestDensityMultiNormal}
\title{Multivariate normal likelihood}
\usage{
generateTestDensityMultiNormal(mean = c(0, 0, 0),
  sigma = "strongcorrelation", sample = F, n = 1, throwErrors = -1)
}
\arguments{
\item{mean}{vector with the three mean values of the distribution}

\item{sigma}{either a correlation matrix, or "strongcorrelation", or "no correlation"}

\item{sample}{should the function create samples}

\item{n}{number of samples to create}

\item{throwErrors}{parameter for test purpose. Between 0 and 1 for proportion of errors}
}
\description{
Generates a 3 dimensional multivariate normal likelihood function.
}
\details{
3-d multivariate normal density function with mean 2,4,0 and either strong correlation (default), or no correlation.
}
\examples{
# sampling from the test function
x = generateTestDensityMultiNormal(sample  = TRUE, n = 1000)(1000)
correlationPlot(x)
marginalPlot(x)

# generating the the density
density = generateTestDensityMultiNormal(sample  = FALSE)
density(x[1,])
}
\seealso{
\code{\link{testDensityBanana}} \cr
         \code{\link{testLinearModel}}
}
\author{
Florian Hartig
}
