\name{predict.bess}
\alias{predict.bess}
\title{make predictions from a "bess" object.}
\description{
  Similar to other predict methods, which returns predictions from a fitted "\code{bess}" object.
}
\usage{
  \method{predict}{bess}(object, newdata, type = c("ALL", "opt", "AIC", "BIC", "GIC"),...)
}
\arguments{
  \item{object}{Output from the \code{bess} function or the \code{bess.one} function.}
  \item{newdata}{New data used for prediction.}
  \item{type}{Types of predictor returned. \code{ type = "AIC"} cooresponds to the predictor with optimal AIC value; \code{ type = "BIC"} cooresponds to the predictor with optimal BIC value;
\code{ type = "GIC"} cooresponds to the predictor with optimal GIC value;\code{ type = "ALL"} cooresponds to all predictors in the \code{bess} object; \code{ type = "opt"} cooresponds to predictors in best model. Default is \code{ALL}. }
  \item{\dots}{Additional arguments affecting the predictions produced.}
}
\value{The object returned depends on the types of family.}

\author{
  Canhong Wen, Aijun Zhang, Shijie Quan, and Xueqin Wang.
}
\references{
 Wen, C., Zhang, A., Quan, S. and Wang, X. (2017). BeSS: an R package for best subset selection in linear, logistic and CoxPH models. arXiv: 1709.06254.
}

\seealso{
\code{\link{bess}}, \code{\link{bess.one}}
}

\examples{

data <- gen.data(500, 20, family = "gaussian", 10, 0.2, 1)
fit <- bess(data$x, data$y, family = "gaussian")
pred=predict(fit, newdata = data$x)

}
