/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.util.Taxon;
import dr.util.XHTMLable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ResamplePatterns
implements PatternList,
XHTMLable {
    protected SiteList patterns = null;
    protected int patternCount = 0;
    protected double[] weights;
    protected int[] patternIndices;
    protected String id = null;

    public void setPatterns(SiteList siteList) {
        this.patterns = siteList;
    }

    public abstract void resamplePatterns();

    @Override
    public int getPatternCount() {
        return this.patternCount;
    }

    @Override
    public int getStateCount() {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getStateCount();
    }

    @Override
    public int getPatternLength() {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getPatternLength();
    }

    @Override
    public int[] getPattern(int n) {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getPattern(this.patternIndices[n]);
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getUncertainPattern(this.patternIndices[n]);
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.getPattern(n2)[n];
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        return this.getUncertainPattern(n2)[n];
    }

    @Override
    public double getPatternWeight(int n) {
        return this.weights[n];
    }

    @Override
    public double[] getPatternWeights() {
        return this.weights;
    }

    @Override
    public int getPatternIndex(int n) {
        return -1;
    }

    @Override
    public DataType getDataType() {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getDataType();
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return this.patterns.areUnique();
    }

    @Override
    public boolean areUncertain() {
        return this.patterns.areUncertain();
    }

    @Override
    public int getTaxonCount() {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        if (this.patterns == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.patterns.getTaxonIndex(taxon);
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (this.patterns == null) {
            throw new RuntimeException("ResamplePatterns has no source patterns");
        }
        return this.patterns.getTaxonAttribute(n, string);
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < ResamplePatterns.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return ResamplePatterns.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String toXHTML() {
        int n;
        int n2;
        String string = "<p><em>Jackknife Pattern List</em>  pattern count = ";
        string = string + this.getPatternCount();
        string = string + "</p>";
        string = string + "<pre>";
        int n3 = this.getDataType().getType();
        int n4 = this.getPatternCount();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            if (n <= n5) continue;
            n5 = n;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n6;
            for (n6 = n = Integer.toString(n2 + 1).length(); n6 < n5; ++n6) {
                string = string + " ";
            }
            string = string + Integer.toString(n2 + 1) + ": ";
            n = Integer.toString((int)this.getPatternWeight(n2)).length();
            string = string + Integer.toString((int)this.getPatternWeight(n2));
            for (n6 = n; n6 <= n5; ++n6) {
                string = string + " ";
            }
            for (n6 = 0; n6 < this.getTaxonCount(); ++n6) {
                int n7 = this.getPatternState(n6, n2);
                string = n3 == 0 ? string + Nucleotides.INSTANCE.getChar(n7) + " " : (n3 == 2 ? string + Codons.UNIVERSAL.getTriplet(n7) + " " : string + AminoAcids.INSTANCE.getChar(n7) + " ");
            }
            string = string + "\n";
        }
        string = string + "</pre>";
        return string;
    }
}

