/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel;

import dr.app.beast.BeastVersion;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.EmpiricalTreeDistributionModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.TabDelimitedFormatter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.trace.LogFileTraces;
import dr.math.MathUtils;
import dr.util.Timer;
import dr.util.Transform;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class SampleFromLogFiles {
    private final List<TreeBinding> treeBindings = new ArrayList<TreeBinding>();
    private final List<ParameterBinding> parameterBindings = new ArrayList<ParameterBinding>();
    private final List<CheckBinding> checkBindings = new ArrayList<CheckBinding>();
    private final List<dr.inference.loggers.Logger> loggers;
    private final LogColumn[] log;
    private final TabDelimitedFormatter formatter;
    private final boolean printToScreen;
    private final Timer timer = new Timer();

    public SampleFromLogFiles(List<Loggable> list, List<dr.inference.loggers.Logger> list2, PrintWriter printWriter, boolean bl) {
        int n = 0;
        for (Loggable object : list) {
            n += object.getColumns().length;
        }
        this.log = new LogColumn[n];
        int n2 = 0;
        for (Loggable loggable : list) {
            LogColumn[] logColumnArray;
            LogColumn[] logColumnArray2 = logColumnArray = loggable.getColumns();
            int n3 = logColumnArray2.length;
            for (int i = 0; i < n3; ++i) {
                LogColumn logColumn;
                this.log[n2] = logColumn = logColumnArray2[i];
                ++n2;
            }
        }
        this.formatter = new TabDelimitedFormatter(printWriter);
        this.printToScreen = bl;
        this.loggers = list2;
    }

    private void printTitle() {
        BeastVersion beastVersion = new BeastVersion();
        String string = "BEAST " + beastVersion.getVersionString() + "\nGenerated " + new Date() + " [seed=" + MathUtils.getSeed() + "]\n" + System.getProperty("command_line", "");
        this.formatter.logHeading(string);
    }

    private void setParameter(ParameterBinding parameterBinding, int n) {
        Parameter parameter = parameterBinding.parameter;
        LogFileTraces logFileTraces = parameterBinding.traces;
        int n2 = parameterBinding.index;
        Transform transform = parameterBinding.transform;
        for (int i = 0; i < parameter.getDimension(); ++i) {
            double d = logFileTraces.getTrace(n2 + i).getValue(n);
            if (transform != null) {
                d = transform.transform(d);
            }
            parameter.setParameterValueQuietly(i, d);
        }
        parameter.fireParameterChangedEvent();
    }

    private void setTree(TreeBinding treeBinding, int n) {
        EmpiricalTreeDistributionModel empiricalTreeDistributionModel = treeBinding.treeModel;
        empiricalTreeDistributionModel.setTree(n);
    }

    private void check(CheckBinding checkBinding, int n) {
        double d;
        Likelihood likelihood = checkBinding.likelihood;
        LogFileTraces logFileTraces = checkBinding.traces;
        int n2 = checkBinding.index;
        double d2 = checkBinding.tolerance;
        double d3 = likelihood.getLogLikelihood();
        if (Math.abs(d3 - (d = logFileTraces.getTrace(n2).getValue(n))) > d2) {
            throw new RuntimeException("Check failed: restored value (" + d3 + ") != log value (" + d + ")");
        }
    }

    private StateInfo ensureCompatibleLogs() {
        StateInfo stateInfo = null;
        if (this.parameterBindings.size() > 0) {
            ParameterBinding parameterBinding = this.parameterBindings.get(0);
            long l = parameterBinding.traces.getMaxState();
            long l2 = parameterBinding.traces.getStepSize();
            long l3 = parameterBinding.traces.getFirstState();
            stateInfo = new StateInfo(l3, l, l2);
            for (int i = 1; i < this.parameterBindings.size(); ++i) {
                ParameterBinding parameterBinding2 = this.parameterBindings.get(i);
                if (parameterBinding2.traces.getMaxState() == stateInfo.maxState && parameterBinding2.traces.getStepSize() == stateInfo.stepSize && parameterBinding2.traces.getFirstState() == stateInfo.firstState) continue;
                throw new RuntimeException("Mis-balanced log file");
            }
        }
        if (this.treeBindings.size() > 0) {
            for (TreeBinding treeBinding : this.treeBindings) {
                int n = treeBinding.trees.size();
                String string = treeBinding.trees.get(0).getId();
                String string2 = treeBinding.trees.get(1).getId();
                String string3 = treeBinding.trees.get(n - 1).getId();
                long l = Long.parseLong(string.replace("STATE_", ""));
                long l4 = Long.parseLong(string2.replace("STATE_", ""));
                long l5 = Long.parseLong(string3.replace("STATE_", ""));
                if (stateInfo == null) {
                    stateInfo = new StateInfo(l, l5, l4 - l);
                }
                if (l5 == stateInfo.maxState && l == stateInfo.firstState && l4 - l == stateInfo.stepSize && n == stateInfo.stateCount) continue;
                throw new RuntimeException("Mis-balanced tree log file");
            }
        }
        return stateInfo;
    }

    public void run(long l, long l2, int n) {
        StateInfo stateInfo = this.ensureCompatibleLogs();
        if (l == -1L) {
            l = stateInfo.firstState;
        }
        if (l2 == -1L) {
            l2 = stateInfo.maxState;
        }
        int n2 = (int)((l - stateInfo.firstState) / stateInfo.stepSize);
        int n3 = (int)((l2 - stateInfo.firstState) / stateInfo.stepSize);
        int n4 = n3 - n2 + 1;
        this.printTitle();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sample");
        arrayList.add("state");
        for (LogColumn object2 : this.log) {
            arrayList.add(object2.getLabel());
        }
        this.formatter.logLabels(arrayList.toArray(new String[0]));
        for (dr.inference.loggers.Logger logger : this.loggers) {
            logger.startLogging();
        }
        this.timer.start();
        for (int i = 0; i < n; ++i) {
            int n5 = n2 + MathUtils.nextInt(n4);
            for (ParameterBinding parameterBinding : this.parameterBindings) {
                this.setParameter(parameterBinding, n5);
            }
            for (TreeBinding treeBinding : this.treeBindings) {
                this.setTree(treeBinding, n5);
            }
            for (CheckBinding checkBinding : this.checkBindings) {
                this.check(checkBinding, n5);
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(Integer.toString(i));
            arrayList2.add(Long.toString(stateInfo.getState(n5)));
            for (LogColumn logColumn : this.log) {
                arrayList2.add(logColumn.getFormatted());
            }
            this.formatter.logValues(arrayList2.toArray(new String[0]));
            for (dr.inference.loggers.Logger logger : this.loggers) {
                logger.log(stateInfo.getState(n5));
            }
            if (!this.printToScreen) continue;
            Logger.getLogger("dr.evomodelxml").info("Iteration " + i + " completed.");
        }
        this.timer.stop();
        this.formatter.stopLogging();
        for (dr.inference.loggers.Logger logger : this.loggers) {
            logger.stopLogging();
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void addTreeBinding(TreeBinding treeBinding) {
        this.treeBindings.add(treeBinding);
    }

    public void addParameterBinding(ParameterBinding parameterBinding) {
        this.parameterBindings.add(parameterBinding);
    }

    public void addCheckBinding(CheckBinding checkBinding) {
        this.checkBindings.add(checkBinding);
    }

    public static class ParameterBinding {
        Parameter parameter;
        LogFileTraces traces;
        int index;
        Transform transform;

        public ParameterBinding(Parameter parameter, LogFileTraces logFileTraces, int n, Transform transform) {
            this.parameter = parameter;
            this.traces = logFileTraces;
            this.index = n;
            this.transform = transform;
        }
    }

    public static class TreeBinding {
        List<Tree> trees;
        EmpiricalTreeDistributionModel treeModel;

        public TreeBinding(EmpiricalTreeDistributionModel empiricalTreeDistributionModel) {
            this.treeModel = empiricalTreeDistributionModel;
            this.trees = empiricalTreeDistributionModel.getTrees();
        }
    }

    public static class CheckBinding {
        Likelihood likelihood;
        LogFileTraces traces;
        int index;
        double tolerance;

        public CheckBinding(Likelihood likelihood, LogFileTraces logFileTraces, int n, double d) {
            this.likelihood = likelihood;
            this.traces = logFileTraces;
            this.index = n;
            this.tolerance = d;
        }
    }

    private static class StateInfo {
        long firstState;
        long maxState;
        long stepSize;
        int stateCount;

        public StateInfo(long l, long l2, long l3) {
            this.firstState = l;
            this.maxState = l2;
            this.stepSize = l3;
            this.stateCount = (int)((l2 - l) / l3) + 1;
        }

        public long getState(int n) {
            return (long)n * this.stepSize + this.firstState;
        }
    }
}

