/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import dr.inference.model.BooleanStatistic;
import java.util.Collections;
import java.util.Set;

public class MonophylyStatistic
extends TreeStatistic
implements BooleanStatistic {
    private Tree tree = null;
    private Set<String> leafSet = null;
    private Set<String> ignoreLeafSet = null;
    private boolean inverse = false;

    public MonophylyStatistic(String string, Tree tree, TaxonList taxonList, TaxonList taxonList2) throws TreeUtils.MissingTaxonException {
        this(string, tree, taxonList, taxonList2, false);
    }

    public MonophylyStatistic(String string, Tree tree, TaxonList taxonList, TaxonList taxonList2, boolean bl) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.leafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
        this.ignoreLeafSet = taxonList2 != null ? TreeUtils.getLeavesForTaxa(tree, taxonList2) : Collections.emptySet();
        this.inverse = bl;
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        boolean bl = TreeUtils.isMonophyletic(this.tree, this.leafSet, this.ignoreLeafSet);
        if (this.inverse) {
            return !bl;
        }
        return bl;
    }
}

