/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.evomodel.substmodel.GlmSubstitutionModel;
import dr.evomodel.substmodel.LogAdditiveCtmcRateProvider;
import dr.evomodel.substmodel.LogRateSubstitutionModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.AbstractLogAdditiveSubstitutionModelGradient;
import dr.inference.loggers.LogColumn;
import dr.inference.model.Parameter;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.List;

public class LogCtmcRateGradient
extends AbstractLogAdditiveSubstitutionModelGradient {
    private final LogAdditiveCtmcRateProvider.DataAugmented rateProvider;
    private final int[][] mapEffectToIndices;

    public LogCtmcRateGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, GlmSubstitutionModel glmSubstitutionModel) {
        super(string, treeDataLikelihood, beagleDataLikelihoodDelegate, glmSubstitutionModel, AbstractLogAdditiveSubstitutionModelGradient.ApproximationMode.FIRST_ORDER);
        this.rateProvider = this.extractRateProvider(glmSubstitutionModel);
        this.mapEffectToIndices = this.makeAsymmetricMap();
    }

    public LogCtmcRateGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, LogRateSubstitutionModel logRateSubstitutionModel) {
        super(string, treeDataLikelihood, beagleDataLikelihoodDelegate, logRateSubstitutionModel, AbstractLogAdditiveSubstitutionModelGradient.ApproximationMode.FIRST_ORDER);
        this.rateProvider = this.extractRateProvider(logRateSubstitutionModel);
        this.mapEffectToIndices = this.makeAsymmetricMap();
    }

    private LogAdditiveCtmcRateProvider.DataAugmented extractRateProvider(ComplexSubstitutionModel complexSubstitutionModel) {
        if (complexSubstitutionModel.getRateProvider() instanceof LogAdditiveCtmcRateProvider.DataAugmented) {
            return (LogAdditiveCtmcRateProvider.DataAugmented)complexSubstitutionModel.getRateProvider();
        }
        throw new IllegalArgumentException("Invalid substitution model");
    }

    @Override
    protected double preProcessNormalization(double[] dArray, double[] dArray2, boolean bl) {
        double d = 0.0;
        if (bl) {
            for (int i = 0; i < this.stateCount; ++i) {
                for (int j = 0; j < this.stateCount; ++j) {
                    int n = i * this.stateCount + j;
                    d += dArray[n] * dArray2[n];
                }
            }
        }
        return d;
    }

    private int[][] makeAsymmetricMap() {
        int n;
        int n2;
        int[][] nArrayArray = new int[this.stateCount * (this.stateCount - 1)][];
        int n3 = 0;
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            n = n2 + 1;
            while (n < this.stateCount) {
                nArrayArray[n3++] = new int[]{n2, n++};
            }
        }
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            n = n2 + 1;
            while (n < this.stateCount) {
                nArrayArray[n3++] = new int[]{n++, n2};
            }
        }
        return nArrayArray;
    }

    @Override
    double processSingleGradientDimension(int n, double[] dArray, double[] dArray2, double[] dArray3, boolean bl, double d) {
        int n2 = this.mapEffectToIndices[n][0];
        int n3 = this.mapEffectToIndices[n][1];
        int n4 = n2 * this.stateCount + n2;
        int n5 = n2 * this.stateCount + n3;
        double d2 = dArray2[n5];
        double d3 = (dArray[n5] - dArray[n4]) * d2;
        if (bl) {
            d3 -= d2 * dArray3[n2] * d;
        }
        return d3;
    }

    @Override
    public Parameter getParameter() {
        return this.rateProvider.getLogRateParameter();
    }

    @Override
    public LogColumn[] getColumns() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2014_UNIFYING);
    }
}

