/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.distributions;

import dr.geo.math.Space;
import dr.geo.math.SphericalPolarCoordinates;
import dr.math.distributions.MultivariateDistribution;

public abstract class HyperSphereDistribution
implements MultivariateDistribution {
    protected static double LOG_2_PI = Math.log(Math.PI * 2);
    private static double tolerance = 1.0E-10;
    protected int dim;
    protected Space space;
    protected double[] mean;
    protected double kappa;

    public HyperSphereDistribution(int n, Space space, double[] dArray, double d) {
        this.dim = n;
        this.mean = dArray;
        this.kappa = d;
        this.space = space;
        this.checkImplementation();
    }

    @Override
    public abstract double logPdf(double[] var1);

    @Override
    public double[][] getScaleMatrix() {
        return new double[0][];
    }

    @Override
    public double[] getMean() {
        return new double[0];
    }

    @Override
    public String getType() {
        return "Hyperspherical";
    }

    protected int getAllowableDim() {
        return this.dim;
    }

    protected void checkImplementation() {
        int n = this.getAllowableDim();
        if (n != this.dim) {
            throw new RuntimeException(this.getType() + " distribution is not implemented in R^" + this.dim);
        }
    }

    public static double innerProduct(double[] dArray, double[] dArray2, Space space) {
        switch (space) {
            case LAT_LONG: {
                return HyperSphereDistribution.latLongToCartesianInnerProduct(dArray, dArray2, 1.0);
            }
            case CARTESIAN: {
                return HyperSphereDistribution.cartestianInnerProduct(dArray, dArray2);
            }
            case RADIANS: {
                return HyperSphereDistribution.radiansInnerProduct(dArray, dArray2);
            }
        }
        throw new RuntimeException("Inner product not yet implemented");
    }

    private static double radiansInnerProduct(double[] dArray, double[] dArray2) {
        if (dArray.length != 1 && dArray2.length != 1) {
            throw new RuntimeException("Wrong dimensions");
        }
        return Math.cos(dArray[0] - dArray2[0]);
    }

    private static double cartestianInnerProduct(double[] dArray, double[] dArray2) {
        if (!HyperSphereDistribution.isUnitVector(dArray) || !HyperSphereDistribution.isUnitVector(dArray2)) {
            throw new RuntimeException("Inner produce must be on unit vectors");
        }
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static boolean isUnitVector(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2 * d2;
        }
        return Math.abs(d - 1.0) < tolerance;
    }

    private static double latLongToCartesianInnerProduct(double[] dArray, double[] dArray2, double d) {
        if (dArray.length != 2 || dArray2.length != 2) {
            throw new RuntimeException("Wrong dimensions");
        }
        SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(dArray[0], dArray[1], d);
        SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(dArray2[0], dArray2[1], d);
        return sphericalPolarCoordinates.getCartesianCoordinates().dot(sphericalPolarCoordinates2.getCartesianCoordinates());
    }
}

