/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.List;

public class CompoundModel
implements Model {
    public static final String COMPOUND_MODEL = "compoundModel";
    private String id = null;
    private String name = null;
    private final ArrayList<Model> models = new ArrayList();
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();

    public CompoundModel(String string) {
        this.name = string;
    }

    public void addModel(Model model) {
        if (!this.models.contains(model)) {
            this.models.add(model);
            for (ModelListener modelListener : this.listeners) {
                model.addModelListener(modelListener);
            }
        }
    }

    @Override
    public int getModelCount() {
        return this.models.size();
    }

    @Override
    public final Model getModel(int n) {
        return this.models.get(n);
    }

    @Override
    public boolean isUsed() {
        return this.listeners.size() > 0;
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
        for (Model model : this.models) {
            model.addModelListener(modelListener);
        }
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        for (Model model : this.models) {
            model.removeModelListener(modelListener);
        }
        this.listeners.remove(modelListener);
    }

    @Override
    public void storeModelState() {
        for (Model model : this.models) {
            model.storeModelState();
        }
    }

    @Override
    public void restoreModelState() {
        for (Model model : this.models) {
            model.restoreModelState();
        }
    }

    @Override
    public void acceptModelState() {
        for (Model model : this.models) {
            model.acceptModelState();
        }
    }

    @Override
    public boolean isValidState() {
        for (int i = 0; i < this.models.size(); ++i) {
            if (this.getModel(i).isValidState()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getVariableCount() {
        return 0;
    }

    @Override
    public Variable getVariable(int n) {
        throw new IllegalArgumentException("Compound models don't have parameters");
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getModelName() {
        return this.name;
    }
}

