/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class GaussianTreeTraitGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String TRAIT_GIBBS = "gaussianTreeTraitGibbsOperator";
    private final TreeTrait<double[]> treeTrait;
    private final Parameter traitParameter;
    private final TreeDataLikelihood treeDataLikelihood;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            double d = xMLObject.getDoubleAttribute("weight");
            return new GaussianTreeTraitGibbsOperator(treeDataLikelihood, parameter, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(TreeDataLikelihood.class), new ElementRule(Parameter.class), AttributeRule.newDoubleRule("weight")};
        }

        @Override
        public String getParserDescription() {
            return "samples traits at the tips of the tree from their full conditional distribution";
        }

        @Override
        public Class getReturnType() {
            return GaussianTreeTraitGibbsOperator.class;
        }

        @Override
        public String getParserName() {
            return GaussianTreeTraitGibbsOperator.TRAIT_GIBBS;
        }
    };

    public GaussianTreeTraitGibbsOperator(TreeDataLikelihood treeDataLikelihood, Parameter parameter, double d) {
        this.setWeight(d);
        this.traitParameter = parameter;
        this.treeDataLikelihood = treeDataLikelihood;
        ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate = (ContinuousDataLikelihoodDelegate)treeDataLikelihood.getDataLikelihoodDelegate();
        this.treeTrait = treeDataLikelihood.getTreeTrait(continuousDataLikelihoodDelegate.getDataModel().getTipTraitName());
    }

    @Override
    public String getOperatorName() {
        return TRAIT_GIBBS;
    }

    @Override
    public double doOperation() {
        this.treeDataLikelihood.fireModelChanged();
        double[] dArray = this.treeTrait.getTrait(this.treeDataLikelihood.getTree(), null);
        this.traitParameter.setAllParameterValuesQuietly(dArray);
        this.traitParameter.fireParameterChangedEvent();
        return Double.POSITIVE_INFINITY;
    }
}

