/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import java.util.ArrayList;

public interface LoadingsSamplerConstraints {
    public int getColumnDim(int var1, int var2);

    public int getArrayIndex(int var1, int var2);

    public void allocateStorage(ArrayList<double[][]> var1, ArrayList<double[]> var2, ArrayList<double[]> var3, int var4);

    public static enum ColumnDimProvider implements LoadingsSamplerConstraints
    {
        NONE("none"){

            @Override
            public int getColumnDim(int n, int n2) {
                return n2;
            }

            @Override
            public int getArrayIndex(int n, int n2) {
                return 0;
            }

            @Override
            public void allocateStorage(ArrayList<double[][]> arrayList, ArrayList<double[]> arrayList2, ArrayList<double[]> arrayList3, int n) {
                arrayList.add(new double[n][n]);
                arrayList2.add(new double[n]);
                arrayList3.add(new double[n]);
            }
        }
        ,
        UPPER_TRIANGULAR("upperTriangular"){

            @Override
            public int getColumnDim(int n, int n2) {
                return Math.min(n + 1, n2);
            }

            @Override
            public int getArrayIndex(int n, int n2) {
                return Math.min(n, n2 - 1);
            }

            @Override
            public void allocateStorage(ArrayList<double[][]> arrayList, ArrayList<double[]> arrayList2, ArrayList<double[]> arrayList3, int n) {
                for (int i = 1; i <= n; ++i) {
                    arrayList.add(new double[i][i]);
                    arrayList2.add(new double[i]);
                    arrayList3.add(new double[i]);
                }
            }
        }
        ,
        FIRST_ROW("firstRow"){

            @Override
            public int getColumnDim(int n, int n2) {
                return 1;
            }

            @Override
            public int getArrayIndex(int n, int n2) {
                return 0;
            }

            @Override
            public void allocateStorage(ArrayList<double[][]> arrayList, ArrayList<double[]> arrayList2, ArrayList<double[]> arrayList3, int n) {
                arrayList.add(new double[1][1]);
                arrayList2.add(new double[1]);
                arrayList3.add(new double[1]);
            }
        }
        ,
        HYBRID("hybrid"){

            @Override
            public int getColumnDim(int n, int n2) {
                if (n == 0) {
                    return 1;
                }
                return n2;
            }

            @Override
            public int getArrayIndex(int n, int n2) {
                if (n == 0) {
                    return 0;
                }
                return 1;
            }

            @Override
            public void allocateStorage(ArrayList<double[][]> arrayList, ArrayList<double[]> arrayList2, ArrayList<double[]> arrayList3, int n) {
                arrayList.add(new double[1][1]);
                arrayList2.add(new double[1]);
                arrayList3.add(new double[1]);
                arrayList.add(new double[n][n]);
                arrayList2.add(new double[n]);
                arrayList3.add(new double[n]);
            }
        };

        private String name;

        private static int[] convertToIndices(int n) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            return nArray;
        }

        public int[] getColumnIndices(int n, int n2) {
            return ColumnDimProvider.convertToIndices(this.getColumnDim(n, n2));
        }

        private ColumnDimProvider(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public static ColumnDimProvider parse(String string) {
            string = string.toLowerCase();
            for (ColumnDimProvider columnDimProvider : ColumnDimProvider.values()) {
                if (string.compareTo(columnDimProvider.getName().toLowerCase()) != 0) continue;
                return columnDimProvider;
            }
            throw new IllegalArgumentException("Unknown dimension provider type");
        }
    }
}

