/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.inference.distribution.LogLinearModel;
import dr.inference.loggers.LogColumn;
import dr.inference.model.BayesianStochasticSearchVariableSelection;
import dr.inference.model.Model;
import dr.oldevomodel.substmodel.ComplexSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.List;

public class NotUsedGlmSubstitutionModel
extends ComplexSubstitutionModel {
    private LogLinearModel glm;
    private double[] testProbabilities;

    public NotUsedGlmSubstitutionModel(String string, DataType dataType, FrequencyModel frequencyModel, LogLinearModel logLinearModel) {
        super(string, dataType, frequencyModel, null);
        this.glm = logLinearModel;
        this.addModel(logLinearModel);
        this.testProbabilities = new double[this.stateCount * this.stateCount];
    }

    @Override
    public double[] getRates() {
        return this.glm.getXBeta();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.glm) {
            this.updateMatrix = true;
            this.fireModelChanged();
        } else {
            super.handleModelChangedEvent(model, object, n);
        }
    }

    @Override
    public LogColumn[] getColumns() {
        return this.glm.getColumns();
    }

    @Override
    public double getLogLikelihood() {
        double d = super.getLogLikelihood();
        if (d == 0.0 && BayesianStochasticSearchVariableSelection.Utils.connectedAndWellConditioned(this.testProbabilities, this)) {
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public String getDescription() {
        return "Generalized linear (model, GLM) substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2014_UNIFYING);
    }
}

