/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.ArrayList;
import java.util.List;
import jebl.evolution.align.PairwiseAligner;
import jebl.evolution.distances.BasicDistanceMatrix;
import jebl.evolution.distances.CannotBuildDistanceMatrixException;
import jebl.evolution.distances.F84DistanceMatrix;
import jebl.evolution.distances.HKYDistanceMatrix;
import jebl.evolution.distances.JukesCantorDistanceMatrix;
import jebl.evolution.distances.TamuraNeiDistanceMatrix;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.TreeBuilderFactory;
import jebl.util.CompositeProgressListener;
import jebl.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceAlignmentsDistanceMatrix
extends BasicDistanceMatrix {
    public SequenceAlignmentsDistanceMatrix(List<Sequence> seqs, PairwiseAligner aligner, ProgressListener progress) throws CannotBuildDistanceMatrixException {
        super(SequenceAlignmentsDistanceMatrix.getTaxa(seqs), SequenceAlignmentsDistanceMatrix.getDistances(seqs, aligner, SequenceAlignmentsDistanceMatrix.getDefaultDistanceModel(seqs), progress));
    }

    public SequenceAlignmentsDistanceMatrix(List<Sequence> seqs, PairwiseAligner aligner, ProgressListener progress, TreeBuilderFactory.DistanceModel model) throws CannotBuildDistanceMatrixException {
        super(SequenceAlignmentsDistanceMatrix.getTaxa(seqs), SequenceAlignmentsDistanceMatrix.getDistances(seqs, aligner, model, progress));
        boolean isProtein;
        boolean bl = isProtein = seqs.get(0).getSequenceType().getCanonicalStateCount() > 4;
        if (model != TreeBuilderFactory.DistanceModel.JukesCantor && isProtein) {
            throw new IllegalArgumentException("Model " + (Object)((Object)model) + " does not support protein sequences");
        }
    }

    static List<Taxon> getTaxa(List<Sequence> seqs) {
        ArrayList<Taxon> t = new ArrayList<Taxon>();
        for (Sequence s : seqs) {
            t.add(s.getTaxon());
        }
        return t;
    }

    public static TreeBuilderFactory.DistanceModel getDefaultDistanceModel(List<Sequence> seqs) {
        boolean isProtein;
        boolean bl = isProtein = seqs.get(0).getSequenceType().getCanonicalStateCount() > 4;
        if (isProtein) {
            return TreeBuilderFactory.DistanceModel.JukesCantor;
        }
        return TreeBuilderFactory.DistanceModel.F84;
    }

    private static String getNotEnoughMemoryMessage(long memoryRequired) {
        return "Not enough memory to build distance matrix. " + String.format("%,d", memoryRequired / 1000L / 1000L) + " MB required";
    }

    private static double[][] getDistances(List<Sequence> seqs, PairwiseAligner aligner, TreeBuilderFactory.DistanceModel model, ProgressListener progressListener) throws CannotBuildDistanceMatrixException {
        double[][] d;
        long maxMemory;
        int n = seqs.size();
        long memoryRequired = (long)n * (long)n * 8L;
        if (n > 100 && memoryRequired > (maxMemory = Runtime.getRuntime().maxMemory())) {
            throw new CannotBuildDistanceMatrixException(SequenceAlignmentsDistanceMatrix.getNotEnoughMemoryMessage(memoryRequired));
        }
        try {
            d = new double[n][n];
        }
        catch (OutOfMemoryError e) {
            throw new CannotBuildDistanceMatrixException(SequenceAlignmentsDistanceMatrix.getNotEnoughMemoryMessage(memoryRequired));
        }
        CompositeProgressListener compositeProgressListener = new CompositeProgressListener(progressListener, n * (n - 1));
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                BasicDistanceMatrix matrix;
                compositeProgressListener.beginSubtask();
                PairwiseAligner.Result result = aligner.doAlignment(seqs.get(i), seqs.get(j), compositeProgressListener);
                if (progressListener.isCanceled()) {
                    return d;
                }
                compositeProgressListener.beginSubtask();
                switch (model) {
                    case F84: {
                        matrix = new F84DistanceMatrix(result.alignment, compositeProgressListener);
                        break;
                    }
                    case HKY: {
                        matrix = new HKYDistanceMatrix(result.alignment, compositeProgressListener);
                        break;
                    }
                    case TamuraNei: {
                        matrix = new TamuraNeiDistanceMatrix(result.alignment, compositeProgressListener);
                        break;
                    }
                    default: {
                        matrix = new JukesCantorDistanceMatrix(result.alignment, compositeProgressListener);
                    }
                }
                d[i][j] = matrix.getDistances()[0][1];
                d[j][i] = d[i][j];
            }
        }
        return d;
    }
}

