% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_PP.R
\name{evidence_PP}
\alias{evidence_PP}
\title{Evidence estimation via power posteriors}
\usage{
evidence_PP(formula, prior.mean, prior.sigma, nits, burnin, thin = 1,
  tunePL = 2, seed = 1, temps = seq(0, 1, length.out = 50)^5,
  info.adjustPL)
}
\arguments{
\item{formula}{formula; an \code{R} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link{network}} object
and <model terms> are \code{ergm-terms}.}

\item{prior.mean}{vector; Prior means.}

\item{prior.sigma}{matrix; Prior covariance matrix.}

\item{nits}{count; Number of MCMC iterations after burn-in for the adjusted pseudo-posterior estimation.}

\item{burnin}{count; Number of burn-in iterations at the beginning of an MCMC run for the adjusted pseudo-posterior estimation.}

\item{thin}{count; Thinning interval used in the simulation for the adjusted pseudo-posterior estimation. The number of MCMC iterations must be divisible by this value.}

\item{tunePL}{count; Tuning parameter for the Metropolis sampling for the pseudo-posterior estimation.}

\item{seed}{The seed for the random number generator. See \code{\link[MCMCpack]{MCMCmetrop1R}}.}

\item{temps}{numeric vector; Inverse temperature ladder, \eqn{t\in[0,1]}.}

\item{info.adjustPL}{Transformation parameters for
adjusting the pseudolikelihood function \code{\link[Bergm]{adjustPL}}.}
}
\description{
Function to estimate the evidence (marginal likelihood) with Power posteriors, 
based on the adjusted pseudolikelihood function.
}
\examples{
\dontrun{
# Load the florentine marriage network:
data(florentine)

flo.formula <- flomarriage ~ edges + kstar(2)

info.adjustPL <- adjustPL(formula = flo.formula,
                          aux.iters    = 100, 
                          noisy.nsim   = 50,   
                          noisy.thin   = 50,   
                          ladder       = 30,   
                          estimate     = "MLE",
                          control      = control.ergm(MCMC.samplesize=2000))

                         
# Specify location and shape of prior distribution: 
prior.mean  <- rep(0, 2)
prior.sigma <- diag(5, 2)   

pp.est.evidence <- evidence_PP(formula = flo.formula,
                               prior.mean = prior.mean,   
                               prior.sigma = prior.sigma,
                               nits = 10000,
                               burnin = 2000,
                               temps = seq(0, 1, length.out = 20)^5,
                               info.adjustPL = info.adjustPL)
                                   
# MCMC diagnostics and posterior summaries:
bergm.output(pp.est.evidence)
  
# Log-marginal likelihood estimate:             
pp.est.evidence$log.evidence
}

}
\references{
Bouranis, L., Friel, N., & Maire, F. (2018). Bayesian model selection for exponential 
random graph models via adjusted pseudolikelihoods. 
Journal of Computational and Graphical Statistics, 1-13. 
\url{https://arxiv.org/abs/1706.06344}
}
