% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bergm.R
\name{bergm}
\alias{bergm}
\title{Parameter estimation for Bayesian ERGMs}
\usage{
bergm(
  formula,
  prior.mean = NULL,
  prior.sigma = NULL,
  burn.in = 100,
  main.iters = 1000,
  aux.iters = 1000,
  nchains = NULL,
  gamma = 0.5,
  V.proposal = 0.0025,
  startVals = NULL,
  offset.coef = NULL,
  ...
)
}
\arguments{
\item{formula}{formula; 
an \code{\link[ergm]{ergm}} formula object,
of the form  <network> ~ <model terms>
where <network> is a \code{\link[network]{network}} object
and <model terms> are \code{ergm-terms}.}

\item{prior.mean}{vector; 
mean vector of the multivariate Normal prior.
By default set to a vector of 0's.}

\item{prior.sigma}{square matrix; 
variance/covariance matrix for the multivariate Normal prior.
By default set to a diagonal matrix with every diagonal entry equal to 100.}

\item{burn.in}{count; 
number of burn-in iterations for every chain of the population.}

\item{main.iters}{count; 
number of iterations for every chain of the population.}

\item{aux.iters}{count; 
number of auxiliary iterations used for network simulation.}

\item{nchains}{count; 
number of chains of the population MCMC.
By default set to twice the model dimension (number of model terms).}

\item{gamma}{scalar; 
parallel adaptive direction sampling move factor.}

\item{V.proposal}{count; 
diagonal entry for the multivariate Normal proposal.
By default set to 0.0025.}

\item{startVals}{vector;
optional starting values for the parameter estimation.}

\item{offset.coef}{vector;
A vector of coefficients for the offset terms.}

\item{...}{additional arguments, to be passed to lower-level functions.}
}
\description{
Function to fit Bayesian exponential random graphs models
using the approximate exchange algorithm.
}
\examples{
\dontrun{
# Load the florentine marriage network
data(florentine)

# Posterior parameter estimation:
p.flo <- bergm(flomarriage ~ edges + kstar(2),
               burn.in    = 50,
               aux.iters  = 500,
               main.iters = 1000,
               gamma      = 1.2)

# Posterior summaries:
summary(p.flo)
}
}
\references{
Caimo, A. and Friel, N. (2011), "Bayesian Inference for Exponential Random Graph Models,"
Social Networks, 33(1), 41-55. \url{https://arxiv.org/abs/1007.5192}

Caimo, A. and Friel, N. (2014), "Bergm: Bayesian Exponential Random Graphs in R,"
Journal of Statistical Software, 61(2), 1-25. \url{https://www.jstatsoft.org/article/view/v061i02}
}
