% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gpx.R
\name{read_gpx}
\alias{read_gpx}
\alias{plot.gpx_file}
\title{Read GPX File

Reads data in GPX form.
Examples of tourist routes saved in this format can be downloaded from
mapa-turystyczna.pl.}
\usage{
read_gpx(path, name = NULL, uniform = TRUE, dx = 25, span = 0.1)

\method{plot}{gpx_file}(x, ..., type = "profile", color = "magenta")
}
\arguments{
\item{path}{path the the gpx file with information about the route}

\item{name}{name of the route}

\item{uniform}{if TRUE then route will be converted into a uniform grid of points}

\item{dx}{if uniform is TRUE then dx is the grid size}

\item{span}{if uniform is TRUE then span is smoothing parameter}

\item{x}{routs to be plotted}

\item{...}{other parameters}

\item{type}{what should be plotted? 'profile' for profiles, 'difference' for derivative, 'boxplot' absolute derivative}

\item{color}{names of colors for lines}
}
\description{
Read GPX File

Reads data in GPX form.
Examples of tourist routes saved in this format can be downloaded from
mapa-turystyczna.pl.
}
\author{
Przemyslaw Biecek
}
